﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime-sdk-messaging/model/ListChannelMessagesRequest.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ChimeSDKMessaging::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String ListChannelMessagesRequest::SerializePayload() const { return {}; }

Aws::Http::HeaderValueCollection ListChannelMessagesRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  Aws::StringStream ss;
  if (m_chimeBearerHasBeenSet) {
    ss << m_chimeBearer;
    headers.emplace("x-amz-chime-bearer", ss.str());
    ss.str("");
  }

  return headers;
}

void ListChannelMessagesRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_sortOrderHasBeenSet) {
    ss << SortOrderMapper::GetNameForSortOrder(m_sortOrder);
    uri.AddQueryStringParameter("sort-order", ss.str());
    ss.str("");
  }

  if (m_notBeforeHasBeenSet) {
    ss << m_notBefore.ToGmtString(Aws::Utils::DateFormat::ISO_8601);
    uri.AddQueryStringParameter("not-before", ss.str());
    ss.str("");
  }

  if (m_notAfterHasBeenSet) {
    ss << m_notAfter.ToGmtString(Aws::Utils::DateFormat::ISO_8601);
    uri.AddQueryStringParameter("not-after", ss.str());
    ss.str("");
  }

  if (m_maxResultsHasBeenSet) {
    ss << m_maxResults;
    uri.AddQueryStringParameter("max-results", ss.str());
    ss.str("");
  }

  if (m_nextTokenHasBeenSet) {
    ss << m_nextToken;
    uri.AddQueryStringParameter("next-token", ss.str());
    ss.str("");
  }

  if (m_subChannelIdHasBeenSet) {
    ss << m_subChannelId;
    uri.AddQueryStringParameter("sub-channel-id", ss.str());
    ss.str("");
  }
}
