﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime/model/ListAccountsRequest.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Chime::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String ListAccountsRequest::SerializePayload() const { return {}; }

void ListAccountsRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_nameHasBeenSet) {
    ss << m_name;
    uri.AddQueryStringParameter("name", ss.str());
    ss.str("");
  }

  if (m_userEmailHasBeenSet) {
    ss << m_userEmail;
    uri.AddQueryStringParameter("user-email", ss.str());
    ss.str("");
  }

  if (m_nextTokenHasBeenSet) {
    ss << m_nextToken;
    uri.AddQueryStringParameter("next-token", ss.str());
    ss.str("");
  }

  if (m_maxResultsHasBeenSet) {
    ss << m_maxResults;
    uri.AddQueryStringParameter("max-results", ss.str());
    ss.str("");
  }
}
