﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codedeploy/model/RegistrationStatus.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace CodeDeploy {
namespace Model {
namespace RegistrationStatusMapper {

static const int Registered_HASH = HashingUtils::HashString("Registered");
static const int Deregistered_HASH = HashingUtils::HashString("Deregistered");

RegistrationStatus GetRegistrationStatusForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == Registered_HASH) {
    return RegistrationStatus::Registered;
  } else if (hashCode == Deregistered_HASH) {
    return RegistrationStatus::Deregistered;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<RegistrationStatus>(hashCode);
  }

  return RegistrationStatus::NOT_SET;
}

Aws::String GetNameForRegistrationStatus(RegistrationStatus enumValue) {
  switch (enumValue) {
    case RegistrationStatus::NOT_SET:
      return {};
    case RegistrationStatus::Registered:
      return "Registered";
    case RegistrationStatus::Deregistered:
      return "Deregistered";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace RegistrationStatusMapper
}  // namespace Model
}  // namespace CodeDeploy
}  // namespace Aws
