﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/customer-profiles/model/UpdateDomainLayoutRequest.h>

#include <utility>

using namespace Aws::CustomerProfiles::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateDomainLayoutRequest::SerializePayload() const {
  JsonValue payload;

  if (m_descriptionHasBeenSet) {
    payload.WithString("Description", m_description);
  }

  if (m_displayNameHasBeenSet) {
    payload.WithString("DisplayName", m_displayName);
  }

  if (m_isDefaultHasBeenSet) {
    payload.WithBool("IsDefault", m_isDefault);
  }

  if (m_layoutTypeHasBeenSet) {
    payload.WithString("LayoutType", LayoutTypeMapper::GetNameForLayoutType(m_layoutType));
  }

  if (m_layoutHasBeenSet) {
    payload.WithString("Layout", m_layout);
  }

  return payload.View().WriteReadable();
}
