; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2025 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; RUN: igc_opt %s --opaque-pointers -S -o - -types-legalization-pass | FileCheck %s
; REQUIRES: llvm-14-plus

; Test that aggregate load splitting preserves correct alignment for scalar loads.
; This test verifies the fix for a correctness bug where aggregate loads were split
; into scalar loads without preserving the original load instruction's alignment,
; potentially causing undefined behavior for unaligned accesses.

; Packed struct
%struct.Packed = type <{ float, i32, i8, [3 x i8] }>

; Non-packed struct
%struct.NonPacked = type { float, i32, i8 }

; Struct with array
%struct.Nested = type { [2 x float], i32 }

; Array type
%array.type = type [3 x i32]

; Test 1: Packed struct with load/store instructions with alignment 1
; Expected: All scalar loads/stores use align=1 because struct is packed
define void @test_packed_align1(i8* %buf, i8* %out) {
; CHECK-LABEL: @test_packed_align1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[BUF:%.*]], i64 3
; CHECK-NEXT:    [[BC:%.*]] = bitcast ptr [[GEP]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr [[STRUCT_PACKED:%.*]], ptr [[BC]], i32 0, i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[TMP0]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 3, i32 0
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP6]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 3, i32 1
; CHECK-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 3, i32 2
; CHECK-NEXT:    [[TMP11:%.*]] = load i8, ptr [[TMP10]], align 1
; CHECK-NEXT:    [[LD:%.*]] = load [[STRUCT_PACKED]], ptr [[BC]], align 1
; CHECK-NEXT:    [[BC_OUT:%.*]] = bitcast ptr [[OUT:%.*]] to ptr
; CHECK-NEXT:    [[TMP12:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 0
; CHECK-NEXT:    store float [[TMP1]], ptr [[TMP12]], align 1
; CHECK-NEXT:    [[TMP13:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 1
; CHECK-NEXT:    store i32 [[TMP3]], ptr [[TMP13]], align 1
; CHECK-NEXT:    [[TMP14:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 2
; CHECK-NEXT:    store i8 [[TMP5]], ptr [[TMP14]], align 1
; CHECK-NEXT:    [[TMP15:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 3, i32 0
; CHECK-NEXT:    store i8 [[TMP7]], ptr [[TMP15]], align 1
; CHECK-NEXT:    [[TMP16:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 3, i32 1
; CHECK-NEXT:    store i8 [[TMP9]], ptr [[TMP16]], align 1
; CHECK-NEXT:    [[TMP17:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 3, i32 2
; CHECK-NEXT:    store i8 [[TMP11]], ptr [[TMP17]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %gep = getelementptr i8, i8* %buf, i64 3
  %bc = bitcast i8* %gep to %struct.Packed*
  ; Load instruction specifies align=1 (pointer may be unaligned)
  %ld = load %struct.Packed, %struct.Packed* %bc, align 1
  %bc.out = bitcast i8* %out to %struct.Packed*
  ; Same for store instruction
  store %struct.Packed %ld, %struct.Packed* %bc.out, align 1
  ret void
}

; Test 2: Non-packed struct with load/store instructions with alignment 4
; Expected: Scalar loads/stores use ABI alignment (float=4, i32=4, i8=1) because:
;   - Non-packed structs have padding to align fields to their ABI alignment
;   - Loads/store instruction alignment (4) >= all field ABI alignments
define void @test_nonpacked_align4(i8* %buf, i8* %out) {
; CHECK-LABEL: @test_nonpacked_align4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC:%.*]] = bitcast ptr [[BUF:%.*]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr [[STRUCT_NONPACKED:%.*]], ptr [[BC]], i32 0, i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC]], i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC]], i32 0, i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[LD:%.*]] = load [[STRUCT_NONPACKED]], ptr [[BC]], align 4
; CHECK-NEXT:    [[BC_OUT:%.*]] = bitcast ptr [[OUT:%.*]] to ptr
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC_OUT]], i32 0, i32 0
; CHECK-NEXT:    store float [[TMP1]], ptr [[TMP6]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC_OUT]], i32 0, i32 1
; CHECK-NEXT:    store i32 [[TMP3]], ptr [[TMP7]], align 4
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC_OUT]], i32 0, i32 2
; CHECK-NEXT:    store i8 [[TMP5]], ptr [[TMP8]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %bc = bitcast i8* %buf to %struct.NonPacked*
  ; Load instruction specifies align=4 (pointer is known to be 4-byte aligned)
  %ld = load %struct.NonPacked, %struct.NonPacked* %bc, align 4
  %bc.out = bitcast i8* %out to %struct.NonPacked*
  ; Same for store instruction
  store %struct.NonPacked %ld, %struct.NonPacked* %bc.out, align 4
  ret void
}

; Test 3: Non-packed struct with load/store instructions with alignment of 2
; Expected: Scalar loads/stores use align=2 (capped by load/store instruction alignment) for float/i32, align=1 for i8
; The load/store instruction alignment (2) is less than the ABI alignment of float/i32 (4), so we must use align=2
define void @test_nonpacked_align2(i8* %buf, i8* %out) {
; CHECK-LABEL: @test_nonpacked_align2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC:%.*]] = bitcast ptr [[BUF:%.*]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr [[STRUCT_NONPACKED:%.*]], ptr [[BC]], i32 0, i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[TMP0]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC]], i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 2
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC]], i32 0, i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[LD:%.*]] = load [[STRUCT_NONPACKED]], ptr [[BC]], align 2
; CHECK-NEXT:    [[BC_OUT:%.*]] = bitcast ptr [[OUT:%.*]] to ptr
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC_OUT]], i32 0, i32 0
; CHECK-NEXT:    store float [[TMP1]], ptr [[TMP6]], align 2
; CHECK-NEXT:    [[TMP7:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC_OUT]], i32 0, i32 1
; CHECK-NEXT:    store i32 [[TMP3]], ptr [[TMP7]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC_OUT]], i32 0, i32 2
; CHECK-NEXT:    store i8 [[TMP5]], ptr [[TMP8]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %bc = bitcast i8* %buf to %struct.NonPacked*
  ; Load instruction specifies align=2 (pointer is only known to be 2-byte aligned)
  %ld = load %struct.NonPacked, %struct.NonPacked* %bc, align 2
  %bc.out = bitcast i8* %out to %struct.NonPacked*
  ; Same for store instruction
  store %struct.NonPacked %ld, %struct.NonPacked* %bc.out, align 2
  ret void
}

; Test 4: Non-packed struct with no explicit load/store instruction alignment
; Expected: When load/store instruction has no alignment, LLVM assumes the pointer is aligned
;   to the ABI alignment of the aggregate type (which is 4 for this struct).
;   Scalar loads/stores can safely use their ABI alignment (float=4, i32=4, i8=1)
define void @test_nonpacked_no_align(i8* %buf, i8* %out) {
; CHECK-LABEL: @test_nonpacked_no_align(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC:%.*]] = bitcast ptr [[BUF:%.*]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr [[STRUCT_NONPACKED:%.*]], ptr [[BC]], i32 0, i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC]], i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC]], i32 0, i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[LD:%.*]] = load [[STRUCT_NONPACKED]], ptr [[BC]], align 4
; CHECK-NEXT:    [[BC_OUT:%.*]] = bitcast ptr [[OUT:%.*]] to ptr
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC_OUT]], i32 0, i32 0
; CHECK-NEXT:    store float [[TMP1]], ptr [[TMP6]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC_OUT]], i32 0, i32 1
; CHECK-NEXT:    store i32 [[TMP3]], ptr [[TMP7]], align 4
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr [[STRUCT_NONPACKED]], ptr [[BC_OUT]], i32 0, i32 2
; CHECK-NEXT:    store i8 [[TMP5]], ptr [[TMP8]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %bc = bitcast i8* %buf to %struct.NonPacked*
  ; No explicit alignment on load instruction (defaults to ABI alignment of struct type)
  %ld = load %struct.NonPacked, %struct.NonPacked* %bc
  %bc.out = bitcast i8* %out to %struct.NonPacked*
  ; Same for store instruction
  store %struct.NonPacked %ld, %struct.NonPacked* %bc.out
  ret void
}

; Test 5: Array with load/store instruction with alignment of 4
; Expected: Scalar loads/stores use align=4 (ABI alignment of i32 element type)
;   Arrays have no padding, but load/store instruction alignment (4) == element ABI alignment (4)
define void @test_array_align4(i8* %buf, i8* %out) {
; CHECK-LABEL: @test_array_align4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC:%.*]] = bitcast ptr [[BUF:%.*]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr [3 x i32], ptr [[BC]], i32 0, i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [3 x i32], ptr [[BC]], i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr [3 x i32], ptr [[BC]], i32 0, i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP4]], align 4
; CHECK-NEXT:    [[LD:%.*]] = load [3 x i32], ptr [[BC]], align 4
; CHECK-NEXT:    [[BC_OUT:%.*]] = bitcast ptr [[OUT:%.*]] to ptr
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr [3 x i32], ptr [[BC_OUT]], i32 0, i32 0
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[TMP6]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = getelementptr [3 x i32], ptr [[BC_OUT]], i32 0, i32 1
; CHECK-NEXT:    store i32 [[TMP3]], ptr [[TMP7]], align 4
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr [3 x i32], ptr [[BC_OUT]], i32 0, i32 2
; CHECK-NEXT:    store i32 [[TMP5]], ptr [[TMP8]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %bc = bitcast i8* %buf to %array.type*
  ; Load instruction specifies align=4
  %ld = load %array.type, %array.type* %bc, align 4
  %bc.out = bitcast i8* %out to %array.type*
  ; Same for store instruction
  store %array.type %ld, %array.type* %bc.out, align 4
  ret void
}

; Test 6: Nested struct with arrays, load/store instructions with alignment of 8
; Expected: Scalar loads/stores use ABI alignment (float=4, i32=4)
;   Load/store instruction alignment (8) >= all field ABI alignments
define void @test_nested_align8(i8* %buf, i8* %out) {
; CHECK-LABEL: @test_nested_align8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC:%.*]] = bitcast ptr [[BUF:%.*]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr [[STRUCT_NESTED:%.*]], ptr [[BC]], i32 0, i32 0, i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[STRUCT_NESTED]], ptr [[BC]], i32 0, i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load float, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr [[STRUCT_NESTED]], ptr [[BC]], i32 0, i32 1
; CHECK-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP4]], align 4
; CHECK-NEXT:    [[LD:%.*]] = load [[STRUCT_NESTED]], ptr [[BC]], align 8
; CHECK-NEXT:    [[BC_OUT:%.*]] = bitcast ptr [[OUT:%.*]] to ptr
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr [[STRUCT_NESTED]], ptr [[BC_OUT]], i32 0, i32 0, i32 0
; CHECK-NEXT:    store float [[TMP1]], ptr [[TMP6]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = getelementptr [[STRUCT_NESTED]], ptr [[BC_OUT]], i32 0, i32 0, i32 1
; CHECK-NEXT:    store float [[TMP3]], ptr [[TMP7]], align 4
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr [[STRUCT_NESTED]], ptr [[BC_OUT]], i32 0, i32 1
; CHECK-NEXT:    store i32 [[TMP5]], ptr [[TMP8]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %bc = bitcast i8* %buf to %struct.Nested*
  ; Load instruction specifies align=8 (over-aligned, but safe)
  %ld = load %struct.Nested, %struct.Nested* %bc, align 8
  %bc.out = bitcast i8* %out to %struct.Nested*
  ; Same for store instruction
  store %struct.Nested %ld, %struct.Nested* %bc.out, align 8
  ret void
}

; Test 7: Packed struct with load/store instructions with alignment of 4
; Expected: Still align=1 for all scalar loads/stores because struct is packed.
;   Even though load/store instruction specifies align=4, fields within packed struct
;   may be at byte offsets not aligned to their ABI alignment
define void @test_packed_align4(i8* %buf, i8* %out) {
; CHECK-LABEL: @test_packed_align4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC:%.*]] = bitcast ptr [[BUF:%.*]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr [[STRUCT_PACKED:%.*]], ptr [[BC]], i32 0, i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[TMP0]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 3, i32 0
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[TMP6]], align 1
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 3, i32 1
; CHECK-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC]], i32 0, i32 3, i32 2
; CHECK-NEXT:    [[TMP11:%.*]] = load i8, ptr [[TMP10]], align 1
; CHECK-NEXT:    [[LD:%.*]] = load [[STRUCT_PACKED]], ptr [[BC]], align 4
; CHECK-NEXT:    [[BC_OUT:%.*]] = bitcast ptr [[OUT:%.*]] to ptr
; CHECK-NEXT:    [[TMP12:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 0
; CHECK-NEXT:    store float [[TMP1]], ptr [[TMP12]], align 1
; CHECK-NEXT:    [[TMP13:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 1
; CHECK-NEXT:    store i32 [[TMP3]], ptr [[TMP13]], align 1
; CHECK-NEXT:    [[TMP14:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 2
; CHECK-NEXT:    store i8 [[TMP5]], ptr [[TMP14]], align 1
; CHECK-NEXT:    [[TMP15:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 3, i32 0
; CHECK-NEXT:    store i8 [[TMP7]], ptr [[TMP15]], align 1
; CHECK-NEXT:    [[TMP16:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 3, i32 1
; CHECK-NEXT:    store i8 [[TMP9]], ptr [[TMP16]], align 1
; CHECK-NEXT:    [[TMP17:%.*]] = getelementptr [[STRUCT_PACKED]], ptr [[BC_OUT]], i32 0, i32 3, i32 2
; CHECK-NEXT:    store i8 [[TMP11]], ptr [[TMP17]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %bc = bitcast i8* %buf to %struct.Packed*
  ; Load instruction specifies align=4, but struct is packed so fields may be misaligned
  %ld = load %struct.Packed, %struct.Packed* %bc, align 4
  %bc.out = bitcast i8* %out to %struct.Packed*
  ; Same for store instruction
  store %struct.Packed %ld, %struct.Packed* %bc.out, align 4
  ret void
}
