// Protocol Buffers - Google's data interchange format
// Copyright 2008 Google Inc.  All rights reserved.
// https://developers.google.com/protocol-buffers/
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/protobuf/source_context.proto

package sourcecontextpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

// `SourceContext` represents information about the source of a
// protobuf element, like the file in which it is defined.
type SourceContext struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The path-qualified name of the .proto file that contained the associated
	// protobuf element.  For example: `"google/protobuf/source_context.proto"`.
	FileName      string `protobuf:"bytes,1,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SourceContext) Reset() {
	*x = SourceContext{}
	mi := &file_google_protobuf_source_context_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SourceContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceContext) ProtoMessage() {}

func (x *SourceContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_source_context_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceContext.ProtoReflect.Descriptor instead.
func (*SourceContext) Descriptor() ([]byte, []int) {
	return file_google_protobuf_source_context_proto_rawDescGZIP(), []int{0}
}

func (x *SourceContext) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

var File_google_protobuf_source_context_proto protoreflect.FileDescriptor

const file_google_protobuf_source_context_proto_rawDesc = "" +
	"\n" +
	"$google/protobuf/source_context.proto\x12\x0fgoogle.protobuf\",\n" +
	"\rSourceContext\x12\x1b\n" +
	"\tfile_name\x18\x01 \x01(\tR\bfileNameB\x8a\x01\n" +
	"\x13com.google.protobufB\x12SourceContextProtoP\x01Z6google.golang.org/protobuf/types/known/sourcecontextpb\xa2\x02\x03GPB\xaa\x02\x1eGoogle.Protobuf.WellKnownTypesb\x06proto3"

var (
	file_google_protobuf_source_context_proto_rawDescOnce sync.Once
	file_google_protobuf_source_context_proto_rawDescData []byte
)

func file_google_protobuf_source_context_proto_rawDescGZIP() []byte {
	file_google_protobuf_source_context_proto_rawDescOnce.Do(func() {
		file_google_protobuf_source_context_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_google_protobuf_source_context_proto_rawDesc), len(file_google_protobuf_source_context_proto_rawDesc)))
	})
	return file_google_protobuf_source_context_proto_rawDescData
}

var file_google_protobuf_source_context_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_protobuf_source_context_proto_goTypes = []any{
	(*SourceContext)(nil), // 0: google.protobuf.SourceContext
}
var file_google_protobuf_source_context_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_google_protobuf_source_context_proto_init() }
func file_google_protobuf_source_context_proto_init() {
	if File_google_protobuf_source_context_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_google_protobuf_source_context_proto_rawDesc), len(file_google_protobuf_source_context_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_protobuf_source_context_proto_goTypes,
		DependencyIndexes: file_google_protobuf_source_context_proto_depIdxs,
		MessageInfos:      file_google_protobuf_source_context_proto_msgTypes,
	}.Build()
	File_google_protobuf_source_context_proto = out.File
	file_google_protobuf_source_context_proto_goTypes = nil
	file_google_protobuf_source_context_proto_depIdxs = nil
}
