/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.util.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHeadersFilter
implements RequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(LogHeadersFilter.class);

    @VisibleForTesting
    protected List<String> maskValue(List<String> values) {
        return values.stream().map(e -> e.replaceAll("(?<=keyId=)\"(.*?)\"", "\"REDACTED\"")).collect(Collectors.toList());
    }

    public void intercept(HttpRequest request) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Sending '{}' request to '{}'", (Object)request.method(), (Object)request.uri());
        Map headers = request.headers();
        for (Map.Entry entry : headers.entrySet()) {
            List<String> value = (List<String>)entry.getValue();
            if (entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase("authorization")) {
                value = this.maskValue((List)entry.getValue());
            }
            LOG.debug("Sending header '{}' with value '{}'", entry.getKey(), (Object)value);
        }
    }
}

