/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;

public class Exists
extends Aggregate {
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    public Expression negate() {
        FunctionCall fc = SystemFunction.makeSystemFunction("empty", this.getArguments());
        fc.setLocationId(this.getLocationId());
        return fc;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        VennExpression v;
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        int c = this.argument[0].getCardinality();
        if (c == 49152) {
            return new Literal(BooleanValue.TRUE);
        }
        if (c == 8192) {
            return new Literal(BooleanValue.FALSE);
        }
        if (this.argument[0] instanceof VennExpression && !visitor.isOptimizeForStreaming() && (v = (VennExpression)this.argument[0]).getOperator() == 1) {
            FunctionCall e0 = SystemFunction.makeSystemFunction("exists", new Expression[]{v.getOperands()[0]});
            FunctionCall e1 = SystemFunction.makeSystemFunction("exists", new Expression[]{v.getOperands()[1]});
            return new BooleanExpression(e0, 9, e1).optimize(visitor, contextItemType);
        }
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        SequenceIterator iter = this.argument[0].iterate(c);
        boolean result = (iter.getProperties() & 4) != 0 ? ((LookaheadIterator)iter).hasNext() : iter.next() != null;
        iter.close();
        return result;
    }
}

