/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.InstructionDetails;
import net.sf.saxon.expr.instruct.LocalVariable;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.TraceInstruction;
import net.sf.saxon.expr.instruct.TraceWrapper;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.functions.Current;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StyleElement
extends ElementImpl
implements Locator,
Container,
InstructionInfo {
    protected short[] extensionNamespaces = null;
    private short[] excludedNamespaces = null;
    protected DecimalValue version = null;
    protected StaticContext staticContext = null;
    protected XPathException validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    protected String defaultCollationName = null;
    private boolean explaining = false;
    private StructuredQName objectName;
    private XSLStylesheet containingStylesheet;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;
    public static final int REPORT_UNLESS_FALLBACK_AVAILABLE = 4;
    protected int actionsCompleted = 0;
    public static final int ACTION_VALIDATE = 1;
    public static final int ACTION_COMPILE = 2;
    public static final int ACTION_TYPECHECK = 4;
    public static final int ACTION_OPTIMIZE = 8;
    public static final int ACTION_FIXUP = 16;
    public static final int ACTION_PROCESS_ATTRIBUTES = 32;

    @Override
    public Executable getExecutable() {
        return this.getPreparedStylesheet();
    }

    @Override
    public LocationProvider getLocationProvider() {
        return this.getExecutable().getLocationMap();
    }

    public StaticContext getStaticContext() {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this);
        }
        return this.staticContext;
    }

    @Override
    public int getContainerGranularity() {
        return 1;
    }

    public ExpressionVisitor makeExpressionVisitor() {
        return ExpressionVisitor.make(this.getStaticContext(), this.getExecutable());
    }

    protected boolean isExplaining() {
        return this.explaining;
    }

    public void substituteFor(StyleElement temp) {
        this.setRawParent(temp.getRawParent());
        this.setAttributeList(temp.getAttributeList());
        this.setNamespaceList(temp.getNamespaceList());
        this.setNameCode(temp.getNameCode());
        this.setRawSequenceNumber(temp.getRawSequenceNumber());
        this.extensionNamespaces = temp.extensionNamespaces;
        this.excludedNamespaces = temp.excludedNamespaces;
        this.version = temp.version;
        this.staticContext = temp.staticContext;
        this.validationError = temp.validationError;
        this.reportingCircumstances = temp.reportingCircumstances;
    }

    public void setValidationError(TransformerException reason, int circumstances) {
        this.validationError = XPathException.makeXPathException(reason);
        this.reportingCircumstances = circumstances;
    }

    public boolean isInstruction() {
        return false;
    }

    public boolean isDeclaration() {
        return false;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    protected ItemType getCommonChildItemType() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType t = EmptySequenceTest.getInstance();
        AxisIterator children = this.iterateAxis((byte)3);
        do {
            NodeInfo next;
            if ((next = (NodeInfo)children.next()) == null) {
                return t;
            }
            if (next instanceof StyleElement) {
                ItemType ret = ((StyleElement)next).getReturnedItemType();
                if (ret == null) continue;
                t = Type.getCommonSuperType(t, ret, th);
                continue;
            }
            t = Type.getCommonSuperType(t, NodeKindTest.TEXT, th);
        } while (t != AnyItemType.getInstance());
        return t;
    }

    protected boolean markTailCalls() {
        return false;
    }

    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    protected boolean mayContainFallback() {
        return this.mayContainSequenceConstructor();
    }

    protected boolean mayContainParam(String attName) {
        return false;
    }

    public XSLStylesheet getContainingStylesheet() {
        if (this.containingStylesheet == null) {
            if (this instanceof XSLStylesheet) {
                this.containingStylesheet = (XSLStylesheet)this;
            } else {
                NodeInfo parent = this.getParent();
                if (parent instanceof StyleElement) {
                    this.containingStylesheet = ((StyleElement)parent).getContainingStylesheet();
                } else {
                    return null;
                }
            }
        }
        return this.containingStylesheet;
    }

    public final StructuredQName makeQName(String lexicalQName) throws XPathException, NamespaceException {
        StructuredQName qName;
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, false, this.getConfiguration().getNameChecker(), this);
        }
        catch (XPathException e) {
            e.setIsStaticError(true);
            String code = e.getErrorCodeLocalPart();
            if ("FONS0004".equals(code)) {
                e.setErrorCode("XTSE0280");
            } else if ("FOCA0002".equals(code)) {
                e.setErrorCode("XTSE0020");
            } else if (code == null) {
                e.setErrorCode("XTSE0020");
            }
            throw e;
        }
        if (NamespaceConstant.isReserved(qName.getNamespaceURI())) {
            XPathException err = new XPathException("Namespace prefix " + qName.getPrefix() + " refers to a reserved namespace");
            err.setIsStaticError(true);
            err.setErrorCode("XTSE0080");
            throw err;
        }
        return qName;
    }

    public SavedNamespaceContext makeNamespaceContext() {
        return new SavedNamespaceContext(this.getInScopeNamespaceCodes(), this.getNamePool());
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    protected void processAllAttributes() throws XPathException {
        if (!(this instanceof LiteralResultElement)) {
            this.processDefaultCollationAttribute("");
        }
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo child;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof StyleElement)) continue;
            ((StyleElement)child).processAllAttributes();
            if (!((StyleElement)child).explaining) continue;
            this.explaining = true;
        }
        return;
    }

    public void processStandardAttributes(String namespace) throws XPathException {
        this.processExtensionElementAttribute(namespace);
        this.processExcludedNamespaces(namespace);
        this.processVersionAttribute(namespace);
        this.processDefaultXPathNamespaceAttribute(namespace);
    }

    public String getAttributeValue(String clarkName) {
        int fp = this.getNamePool().allocateClarkName(clarkName);
        return this.getAttributeValue(fp);
    }

    protected final void processAttributes() throws XPathException {
        try {
            this.prepareAttributes();
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    protected void checkUnknownAttribute(int nc) throws XPathException {
        String attributeURI = this.getNamePool().getURI(nc);
        String elementURI = this.getURI();
        String clarkName = this.getNamePool().getClarkName(nc);
        if (clarkName.equals("{http://saxon.sf.net/}explain")) {
            this.explaining = "yes".equals(this.getAttributeValue(nc & 0xFFFFF));
        }
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        if (this.isInstruction() && clarkName.startsWith("{http://www.w3.org/1999/XSL/Transform") && !elementURI.equals("http://www.w3.org/1999/XSL/Transform") && (clarkName.endsWith("}default-collation") || clarkName.endsWith("}xpath-default-namespace") || clarkName.endsWith("}extension-element-prefixes") || clarkName.endsWith("}exclude-result-prefixes") || clarkName.endsWith("}version") || clarkName.endsWith("}use-when"))) {
            return;
        }
        if (elementURI.equals("http://www.w3.org/1999/XSL/Transform") && (clarkName.equals("default-collation") || clarkName.equals("xpath-default-namespace") || clarkName.equals("extension-element-prefixes") || clarkName.equals("exclude-result-prefixes") || clarkName.equals("version") || clarkName.equals("use-when"))) {
            return;
        }
        if ("".equals(attributeURI) || "http://www.w3.org/1999/XSL/Transform".equals(attributeURI)) {
            this.compileError("Attribute " + Err.wrap(this.getNamePool().getDisplayName(nc), 2) + " is not allowed on element " + Err.wrap(this.getDisplayName(), 1), "XTSE0090");
        }
    }

    protected abstract void prepareAttributes() throws XPathException;

    protected StyleElement getLastChildInstruction() {
        StyleElement last = null;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo child;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof StyleElement) {
                last = (StyleElement)child;
                continue;
            }
            last = null;
        }
        return last;
    }

    public Expression makeExpression(String expression) throws XPathException {
        try {
            return ExpressionTool.make(expression, this.staticContext, this, 0, 0, this.getLineNumber(), this.getPreparedStylesheet().isCompileWithTracing());
        }
        catch (XPathException err) {
            err.setLocator(this);
            this.compileError(err);
            ErrorExpression erexp = new ErrorExpression(err);
            erexp.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            erexp.setContainer(this);
            return erexp;
        }
    }

    public Pattern makePattern(String pattern) throws XPathException {
        try {
            return Pattern.make(pattern, this.staticContext, this.getExecutable());
        }
        catch (XPathException err) {
            this.compileError(err);
            return new NodeTestPattern(AnyNodeTest.getInstance());
        }
    }

    protected Expression makeAttributeValueTemplate(String expression) throws XPathException {
        try {
            return AttributeValueTemplate.make(expression, this.getLineNumber(), this.staticContext);
        }
        catch (XPathException err) {
            this.compileError(err);
            return new StringLiteral(expression);
        }
    }

    public SequenceType makeSequenceType(String sequenceType) throws XPathException {
        this.getStaticContext();
        try {
            ExpressionParser parser = this.getConfiguration().newExpressionParser("XP", false, this.staticContext.getXPathLanguageLevel());
            parser.setLanguage(0, this.staticContext.getXPathLanguageLevel());
            return parser.parseSequenceType(sequenceType, this.staticContext);
        }
        catch (XPathException err) {
            this.compileError(err);
            return SequenceType.ANY_SEQUENCE;
        }
    }

    protected void processExtensionElementAttribute(String ns) throws XPathException {
        String ext = this.getAttributeValue(ns, "extension-element-prefixes");
        if (ext != null) {
            int count = 0;
            StringTokenizer st1 = new StringTokenizer(ext, " \t\n\r", false);
            while (st1.hasMoreTokens()) {
                st1.nextToken();
                ++count;
            }
            this.extensionNamespaces = new short[count];
            count = 0;
            StringTokenizer st2 = new StringTokenizer(ext, " \t\n\r", false);
            while (st2.hasMoreTokens()) {
                String s = st2.nextToken();
                if ("#default".equals(s)) {
                    s = "";
                }
                try {
                    short uriCode = this.getURICodeForPrefix(s);
                    this.extensionNamespaces[count++] = uriCode;
                }
                catch (NamespaceException err) {
                    this.extensionNamespaces = null;
                    this.compileError(err.getMessage(), "XTSE1430");
                }
            }
        }
    }

    protected void processExcludedNamespaces(String ns) throws XPathException {
        block10: {
            String ext = this.getAttributeValue(ns, "exclude-result-prefixes");
            if (ext == null) break block10;
            if ("#all".equals(Whitespace.trim(ext))) {
                int[] codes = this.getInScopeNamespaceCodes();
                this.excludedNamespaces = new short[codes.length];
                for (int i = 0; i < codes.length; ++i) {
                    this.excludedNamespaces[i] = (short)(codes[i] & 0xFFFF);
                }
            } else {
                int count = 0;
                StringTokenizer st1 = new StringTokenizer(ext, " \t\n\r", false);
                while (st1.hasMoreTokens()) {
                    st1.nextToken();
                    ++count;
                }
                this.excludedNamespaces = new short[count];
                count = 0;
                StringTokenizer st2 = new StringTokenizer(ext, " \t\n\r", false);
                while (st2.hasMoreTokens()) {
                    String s = st2.nextToken();
                    if ("#default".equals(s)) {
                        s = "";
                    } else if ("#all".equals(s)) {
                        this.compileError("In exclude-result-prefixes, cannot mix #all with other values", "XTSE0020");
                    }
                    try {
                        short uriCode = this.getURICodeForPrefix(s);
                        this.excludedNamespaces[count++] = uriCode;
                        if (s.length() != 0 || uriCode != 0) continue;
                        this.compileError("Cannot exclude the #default namespace when no default namespace is declared", "XTSE0809");
                    }
                    catch (NamespaceException err) {
                        this.excludedNamespaces = null;
                        this.compileError(err.getMessage(), "XTSE0808");
                    }
                }
            }
        }
    }

    protected void processVersionAttribute(String ns) throws XPathException {
        String v = Whitespace.trim(this.getAttributeValue(ns, "version"));
        if (v != null) {
            ConversionResult val = DecimalValue.makeDecimalValue(v, true);
            if (val instanceof ValidationFailure) {
                this.compileError("The version attribute must be a decimal literal", "XTSE0110");
                this.version = DecimalValue.TWO;
            } else {
                this.version = (DecimalValue)val;
            }
        }
    }

    public DecimalValue getEffectiveVersion() {
        if (this.version == null) {
            NodeInfo node = this.getParent();
            if (node instanceof StyleElement) {
                this.version = ((StyleElement)node).getEffectiveVersion();
            } else {
                return DecimalValue.TWO;
            }
        }
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getEffectiveVersion().compareTo(this.getProcessorVersion()) > 0;
    }

    public boolean xPath10ModeIsEnabled() {
        return this.getEffectiveVersion().compareTo(DecimalValue.TWO) < 0;
    }

    public DecimalValue getProcessorVersion() {
        return this.getPreparedStylesheet().getStyleNodeFactory().getXsltProcessorVersion();
    }

    public boolean isXslt30Processor() {
        return this.getProcessorVersion().compareTo(DecimalValue.THREE) >= 0;
    }

    protected void processDefaultCollationAttribute(String ns) throws XPathException {
        String v = this.getAttributeValue(ns, "default-collation");
        if (v != null) {
            StringTokenizer st = new StringTokenizer(v, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String uri = st.nextToken();
                if (uri.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
                    this.defaultCollationName = uri;
                    return;
                }
                if (uri.startsWith("http://saxon.sf.net/")) {
                    this.defaultCollationName = uri;
                    return;
                }
                try {
                    URI collationURI = new URI(uri);
                    if (!collationURI.isAbsolute()) {
                        URI base = new URI(this.getBaseURI());
                        collationURI = base.resolve(collationURI);
                        uri = collationURI.toString();
                    }
                }
                catch (URISyntaxException err) {
                    this.compileError("default collation '" + uri + "' is not a valid URI");
                    uri = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
                }
                if (uri.startsWith("http://saxon.sf.net/")) {
                    this.defaultCollationName = uri;
                    return;
                }
                if (this.getExecutable().getNamedCollation(uri) != null) {
                    this.defaultCollationName = uri;
                    return;
                }
                if (this.getPrincipalStylesheetModule().findCollation(uri, this.getBaseURI()) == null) continue;
                this.defaultCollationName = uri;
                return;
            }
            this.compileError("No recognized collation URI found in default-collation attribute", "XTSE0125");
        }
    }

    protected String getDefaultCollationName() {
        StyleElement e = this;
        while (true) {
            if (e.defaultCollationName != null) {
                return e.defaultCollationName;
            }
            NodeInfo p = e.getParent();
            if (!(p instanceof StyleElement)) break;
            e = (StyleElement)p;
        }
        String globalDefault = this.getConfiguration().getCollationMap().getDefaultCollationName();
        return globalDefault == null ? "http://www.w3.org/2005/xpath-functions/collation/codepoint" : globalDefault;
    }

    protected boolean definesExtensionElement(short uriCode) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.extensionNamespaces.length; ++i) {
            if (this.extensionNamespaces[i] != uriCode) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionNamespace(short uriCode) {
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExtensionElement(uriCode)) {
                return true;
            }
            anc = anc.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(short uriCode) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.excludedNamespaces.length; ++i) {
            if (this.excludedNamespaces[i] != uriCode) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedNamespace(short uriCode) {
        if (uriCode == 2 || uriCode == 1) {
            return true;
        }
        if (this.isExtensionNamespace(uriCode)) {
            return true;
        }
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExcludedNamespace(uriCode)) {
                return true;
            }
            anc = anc.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(String ns) {
        String v = this.getAttributeValue(ns, "xpath-default-namespace");
        if (v != null) {
            this.defaultXPathNamespace = v;
        }
    }

    protected String getDefaultXPathNamespace() {
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            String x = anc.defaultXPathNamespace;
            if (x != null) {
                return x;
            }
            anc = anc.getParent();
        }
        return "";
    }

    public SchemaType getSchemaType(String typeAtt) throws XPathException {
        try {
            String uri;
            String[] parts = this.getConfiguration().getNameChecker().getQNameParts(typeAtt);
            String lname = parts[1];
            if ("".equals(parts[0])) {
                uri = this.getDefaultXPathNamespace();
            } else {
                uri = this.getURIForPrefix(parts[0], false);
                if (uri == null) {
                    this.compileError("Namespace prefix for type annotation is undeclared", "XTSE1520");
                    return null;
                }
            }
            int nc = this.getNamePool().allocate(parts[0], uri, lname);
            if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                SchemaType t;
                if ("untyped".equals(lname)) {
                    this.compileError("Cannot validate a node as 'untyped'", "XTSE1520");
                }
                if ((t = BuiltInType.getSchemaType(StandardNames.getFingerprint(uri, lname))) == null) {
                    this.compileError("Unknown built-in type " + typeAtt, "XTSE1520");
                    return null;
                }
                return t;
            }
            if (!this.getPrincipalStylesheetModule().isImportedSchema(uri)) {
                this.compileError("There is no imported schema for the namespace of type " + typeAtt, "XTSE1520");
                return null;
            }
            SchemaType stype = this.getConfiguration().getSchemaType(nc & 0xFFFFF);
            if (stype == null) {
                this.compileError("There is no type named " + typeAtt + " in an imported schema", "XTSE1520");
            }
            return stype;
        }
        catch (QNameException err) {
            this.compileError("Invalid type name. " + err.getMessage(), "XTSE1520");
            return null;
        }
    }

    public int getTypeAnnotation(SchemaType schemaType) {
        if (schemaType != null) {
            return schemaType.getFingerprint();
        }
        return -1;
    }

    public void validate(Declaration decl) throws XPathException {
    }

    public void postValidate() throws XPathException {
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
    }

    public Expression typeCheck(String name, Expression exp) throws XPathException {
        if (exp == null) {
            return null;
        }
        exp.setContainer(this);
        try {
            exp = this.makeExpressionVisitor().typeCheck(exp, Type.ITEM_TYPE);
            exp = ExpressionTool.resolveCallsToCurrentFunction(exp, this.getConfiguration());
            if (this.getPreparedStylesheet().isCompileWithTracing()) {
                InstructionDetails details = new InstructionDetails();
                details.setConstructType(2011);
                details.setLineNumber(this.getLineNumber());
                details.setSystemId(this.getSystemId());
                details.setProperty("attribute-name", name);
                TraceInstruction trace = new TraceInstruction(exp, details);
                trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                trace.setContainer(this);
                exp = trace;
            }
            return exp;
        }
        catch (XPathException err) {
            if (err.isStaticError() || err.isTypeError()) {
                this.compileError(err);
                return exp;
            }
            ErrorExpression erexp = new ErrorExpression(err);
            erexp.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return erexp;
        }
    }

    public void allocateSlots(Expression exp) {
        SlotManager slotManager = this.getContainingSlotManager();
        if (slotManager == null) {
            throw new AssertionError((Object)"Slot manager has not been allocated");
        }
        int firstSlot = slotManager.getNumberOfVariables();
        int highWater = ExpressionTool.allocateSlots(exp, firstSlot, slotManager);
        if (highWater > firstSlot) {
            slotManager.setNumberOfVariables(highWater);
        }
    }

    public void allocatePatternSlots(int slots) {
        this.getPrincipalStylesheetModule().allocatePatternSlots(slots);
    }

    public Pattern typeCheck(String name, Pattern pattern) throws XPathException {
        if (pattern == null) {
            return null;
        }
        try {
            pattern = pattern.analyze(this.makeExpressionVisitor(), Type.NODE_TYPE);
            boolean usesCurrent = false;
            Iterator sub = pattern.iterateSubExpressions();
            while (sub.hasNext()) {
                Expression filter = (Expression)sub.next();
                if (!ExpressionTool.callsFunction(filter, Current.FN_CURRENT)) continue;
                usesCurrent = true;
                break;
            }
            if (usesCurrent) {
                Configuration config = this.getConfiguration();
                LetExpression let = new LetExpression();
                let.setVariableQName(new StructuredQName("saxon", "http://saxon.sf.net/", "current" + this.hashCode()));
                let.setRequiredType(SequenceType.SINGLE_ITEM);
                let.setSequence(new ContextItemExpression());
                let.setAction(Literal.makeEmptySequence());
                PromotionOffer offer = new PromotionOffer(config.getOptimizer());
                offer.action = 14;
                offer.containingExpression = let;
                pattern.resolveCurrent(let, offer, true);
            }
            return pattern;
        }
        catch (XPathException err) {
            if (err.isReportableStatically()) {
                XPathException e2 = new XPathException("Error in " + name + " pattern", err);
                e2.setLocator(this);
                e2.setErrorCodeQName(err.getErrorCodeQName());
                throw e2;
            }
            LocationPathPattern errpat = new LocationPathPattern();
            errpat.setExecutable(this.getExecutable());
            errpat.addFilter(new ErrorExpression(err));
            return errpat;
        }
    }

    public void fixupReferences() throws XPathException {
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo child;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof StyleElement)) continue;
            ((StyleElement)child).fixupReferences();
        }
        return;
    }

    public SlotManager getContainingSlotManager() {
        NodeInfo node = this;
        while (true) {
            NodeInfo next;
            if ((next = node.getParent()) instanceof XSLStylesheet) {
                if (node instanceof StylesheetProcedure) {
                    return ((StylesheetProcedure)((Object)node)).getSlotManager();
                }
                return null;
            }
            node = next;
        }
    }

    public void validateSubtree(Declaration decl) throws XPathException {
        if (this.isActionCompleted(1)) {
            return;
        }
        this.setActionCompleted(1);
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 4) {
                NodeInfo child;
                boolean hasFallback = false;
                AxisIterator kids = this.iterateAxis((byte)3);
                while ((child = (NodeInfo)kids.next()) != null) {
                    if (!(child instanceof XSLFallback)) continue;
                    hasFallback = true;
                    ((XSLFallback)child).validateSubtree(decl);
                }
                if (!hasFallback) {
                    this.compileError(this.validationError);
                }
            }
        } else {
            try {
                this.validate(decl);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
            this.validateChildren(decl);
            this.postValidate();
        }
    }

    protected void validateChildren(Declaration decl) throws XPathException {
        NodeInfo child;
        boolean containsInstructions = this.mayContainSequenceConstructor();
        AxisIterator kids = this.iterateAxis((byte)3);
        StyleElement lastChild = null;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof StyleElement)) continue;
            if (containsInstructions && !((StyleElement)child).isInstruction() && !this.isPermittedChild((StyleElement)child)) {
                ((StyleElement)child).compileError("An " + this.getDisplayName() + " element must not contain an " + child.getDisplayName() + " element", "XTSE0010");
            }
            ((StyleElement)child).validateSubtree(decl);
            lastChild = (StyleElement)child;
        }
        if (lastChild instanceof XSLVariable && !(this instanceof XSLStylesheet)) {
            lastChild.compileWarning("A variable with no following sibling instructions has no effect", "SXWN9001");
        }
    }

    protected boolean isPermittedChild(StyleElement child) {
        return false;
    }

    public PreparedStylesheet getPreparedStylesheet() {
        XSLStylesheet xss = this.getContainingStylesheet();
        return xss == null ? null : xss.getPreparedStylesheet();
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this.getContainingStylesheet().getPrincipalStylesheetModule();
    }

    protected void checkSortComesFirst(boolean sortRequired) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        boolean sortFound = false;
        boolean nonSortFound = false;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLSort) {
                if (nonSortFound) {
                    ((XSLSort)child).compileError("Within " + this.getDisplayName() + ", xsl:sort elements must come before other instructions", "XTSE0010");
                }
                sortFound = true;
                continue;
            }
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                nonSortFound = true;
                continue;
            }
            nonSortFound = true;
        }
        if (sortRequired && !sortFound) {
            this.compileError(this.getDisplayName() + " must have at least one xsl:sort child", "XTSE0010");
        }
    }

    public void checkTopLevel(String errorCode) throws XPathException {
        if (!(this.getParent() instanceof XSLStylesheet)) {
            this.compileError("Element must be used only at top level of stylesheet", errorCode == null ? "XTSE0010" : errorCode);
        }
    }

    public void checkEmpty() throws XPathException {
        if (this.hasChildNodes()) {
            this.compileError("Element must be empty", "XTSE0260");
        }
    }

    public void reportAbsence(String attribute) throws XPathException {
        this.compileError("Element must have an @" + attribute + " attribute", "XTSE0010");
    }

    public abstract Expression compile(Executable var1, Declaration var2) throws XPathException;

    public Expression compileSequenceConstructor(Executable exec, Declaration decl, SequenceIterator iter, boolean includeParams) throws XPathException {
        NodeInfo node;
        int locationId = this.allocateLocationId(this.getSystemId(), this.getLineNumber());
        ArrayList<Expression> contents = new ArrayList<Expression>(10);
        int lineNumber = this.getLineNumber();
        while ((node = (NodeInfo)iter.next()) != null) {
            Expression child;
            if (node instanceof StyleElement) {
                lineNumber = node.getLineNumber();
            }
            if (node.getNodeKind() == 3) {
                AxisIterator lookahead = node.iterateAxis((byte)7);
                NodeInfo sibling = (NodeInfo)lookahead.next();
                if (sibling instanceof XSLParam || sibling instanceof XSLSort) continue;
                Instruction text = new ValueOf(new StringLiteral(node.getStringValue()), false, false);
                text.setLocationId(this.allocateLocationId(this.getSystemId(), lineNumber));
                if (this.getPreparedStylesheet().isCompileWithTracing()) {
                    text = new TraceInstruction(text, text);
                    text.setLocationId(this.allocateLocationId(this.getSystemId(), lineNumber));
                }
                contents.add(text);
                continue;
            }
            if (node instanceof XSLVariable) {
                Expression var = ((XSLVariable)node).compileLocalVariable(exec, decl);
                if (var == null) continue;
                LocalVariable lv = (LocalVariable)var;
                Expression tail = this.compileSequenceConstructor(exec, decl, iter, includeParams);
                if (tail == null || Literal.isEmptySequence(tail)) continue;
                LetExpression let = new LetExpression();
                let.setRequiredType(lv.getRequiredType());
                let.setVariableQName(lv.getVariableQName());
                let.setSequence(lv.getSelectExpression());
                let.setAction(tail);
                ((XSLVariable)node).fixupBinding(let);
                locationId = this.allocateLocationId(node.getSystemId(), node.getLineNumber());
                let.setLocationId(locationId);
                if (this.getPreparedStylesheet().isCompileWithTracing()) {
                    TraceExpression t = new TraceExpression(let);
                    t.setConstructType(2013);
                    t.setObjectName(lv.getVariableQName());
                    t.setSystemId(node.getSystemId());
                    t.setLineNumber(node.getLineNumber());
                    contents.add(t);
                    continue;
                }
                contents.add(let);
                continue;
            }
            if (!(node instanceof StyleElement)) continue;
            StyleElement snode = (StyleElement)node;
            if (snode.validationError != null && !(this instanceof AbsentExtensionElement)) {
                child = this.fallbackProcessing(exec, decl, snode);
            } else {
                child = snode.compile(exec, decl);
                if (child != null) {
                    if (child.getContainer() == null) {
                        child.setContainer(this);
                    }
                    locationId = this.allocateLocationId(this.getSystemId(), snode.getLineNumber());
                    child.setLocationId(locationId);
                    if ((includeParams || !(node instanceof XSLParam)) && this.getPreparedStylesheet().isCompileWithTracing()) {
                        child = StyleElement.makeTraceInstruction(snode, child);
                    }
                }
            }
            if (child == null) continue;
            contents.add(child);
        }
        Expression block = Block.makeBlock(contents);
        block.setLocationId(locationId);
        return block;
    }

    protected static TraceWrapper makeTraceInstruction(StyleElement source, Expression child) {
        if (child instanceof TraceWrapper) {
            return (TraceWrapper)child;
        }
        TraceInstruction trace = new TraceInstruction(child, source);
        trace.setLocationId(source.allocateLocationId(source.getSystemId(), source.getLineNumber()));
        trace.setContainer(source);
        return trace;
    }

    protected Expression fallbackProcessing(Executable exec, Declaration decl, StyleElement instruction) throws XPathException {
        NodeInfo child;
        Expression fallback = null;
        AxisIterator kids = instruction.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof XSLFallback)) continue;
            Expression b = ((XSLFallback)child).compileSequenceConstructor(exec, decl, child.iterateAxis((byte)3), true);
            if (b == null) {
                b = Literal.makeEmptySequence();
            }
            if (fallback == null) {
                fallback = b;
                continue;
            }
            fallback = Block.makeBlock(fallback, b);
            fallback.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
        }
        if (fallback != null) {
            return fallback;
        }
        return new ErrorExpression(instruction.validationError);
    }

    protected int allocateLocationId(String systemId, int lineNumber) {
        return this.getStaticContext().getLocationMap().allocateLocationId(systemId, lineNumber);
    }

    protected SortKeyDefinition[] makeSortKeys(Declaration decl) throws XPathException {
        Item child;
        int numberOfSortKeys = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof XSLSort)) continue;
            ((XSLSort)child).compile(this.getExecutable(), decl);
            if (numberOfSortKeys != 0 && ((XSLSort)child).getStable() != null) {
                this.compileError("stable attribute may appear only on the first xsl:sort element", "XTSE1017");
            }
            ++numberOfSortKeys;
        }
        if (numberOfSortKeys > 0) {
            NodeInfo child2;
            SortKeyDefinition[] keys = new SortKeyDefinition[numberOfSortKeys];
            kids = this.iterateAxis((byte)3);
            int k = 0;
            while ((child2 = (NodeInfo)kids.next()) != null) {
                if (!(child2 instanceof XSLSort)) continue;
                keys[k++] = ((XSLSort)child2).getSortKeyDefinition().simplify(this.makeExpressionVisitor());
            }
            return keys;
        }
        return null;
    }

    protected AttributeSet[] getAttributeSets(String use, List<Declaration> list) throws XPathException {
        if (list == null) {
            list = new ArrayList<Declaration>(4);
        }
        PrincipalStylesheetModule psm = this.getPrincipalStylesheetModule();
        StringTokenizer st = new StringTokenizer(use, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            boolean found;
            StructuredQName name;
            String asetname = st.nextToken();
            try {
                name = this.makeQName(asetname);
            }
            catch (NamespaceException err) {
                this.compileError(err.getMessage(), "XTSE0710");
                name = null;
            }
            catch (XPathException err) {
                this.compileError(err.getMessage(), "XTSE0710");
                name = null;
            }
            if (found = psm.getAttributeSets(name, list)) continue;
            this.compileError("No attribute-set exists named " + asetname, "XTSE0710");
        }
        AttributeSet[] array = new AttributeSet[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            XSLAttributeSet aset = (XSLAttributeSet)list.get(i).getSourceElement();
            array[i] = aset.getInstruction();
        }
        return array;
    }

    protected WithParam[] getWithParamInstructions(Executable exec, Declaration decl, boolean tunnel, Expression caller) throws XPathException {
        NodeInfo child;
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            XSLWithParam wp;
            if (!(child instanceof XSLWithParam) || (wp = (XSLWithParam)child).isTunnelParam() != tunnel) continue;
            ++count;
        }
        WithParam[] array = new WithParam[count];
        count = 0;
        kids = this.iterateAxis((byte)3);
        NodeInfo child2;
        while ((child2 = (NodeInfo)kids.next()) != null) {
            XSLWithParam wp;
            if (!(child2 instanceof XSLWithParam) || (wp = (XSLWithParam)child2).isTunnelParam() != tunnel) continue;
            WithParam p = (WithParam)wp.compile(exec, decl);
            ExpressionTool.copyLocationInfo(caller, p);
            array[count++] = p;
        }
        return array;
    }

    protected void compileError(XPathException error) throws XPathException {
        error.setIsStaticError(true);
        if (error.getLocator() == null || (error.getLocator() instanceof ExpressionLocation || error.getLocator() instanceof Expression) && !(this instanceof StylesheetProcedure)) {
            error.setLocator(this);
        }
        PreparedStylesheet pss = this.getPreparedStylesheet();
        try {
            if (pss == null) {
                throw error;
            }
            pss.reportError(error);
        }
        catch (TransformerException err2) {
            if (err2.getLocator() == null) {
                err2.setLocator(this);
            }
            throw XPathException.makeXPathException(err2);
        }
    }

    protected void compileError(String message) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setLocator(this);
        this.compileError(tce);
    }

    protected void compileError(String message, StructuredQName errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCodeQName(errorCode);
        tce.setLocator(this);
        this.compileError(tce);
    }

    protected void compileError(String message, String errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        tce.setLocator(this);
        this.compileError(tce);
    }

    protected void undeclaredNamespaceError(String prefix, String errorCode) throws XPathException {
        if (errorCode == null) {
            errorCode = "XTSE0280";
        }
        this.compileError("Undeclared namespace prefix " + Err.wrap(prefix), errorCode);
    }

    protected void compileWarning(String message, StructuredQName errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCodeQName(errorCode);
        tce.setLocator(this);
        PreparedStylesheet pss = this.getPreparedStylesheet();
        if (pss != null) {
            pss.reportWarning(tce);
        }
    }

    protected void compileWarning(String message, String errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        tce.setLocator(this);
        PreparedStylesheet pss = this.getPreparedStylesheet();
        if (pss != null) {
            pss.reportWarning(tce);
        }
    }

    protected void issueWarning(TransformerException error) {
        PreparedStylesheet pss;
        if (error.getLocator() == null) {
            error.setLocator(this);
        }
        if ((pss = this.getPreparedStylesheet()) != null) {
            pss.reportWarning(error);
        }
    }

    protected void issueWarning(String message, SourceLocator locator) {
        TransformerConfigurationException tce = new TransformerConfigurationException(message);
        if (locator == null) {
            tce.setLocator(this);
        } else {
            tce.setLocator(locator);
        }
        this.issueWarning(tce);
    }

    public boolean isTopLevel() {
        return this.getParent() instanceof XSLStylesheet;
    }

    public XSLVariableDeclaration bindVariable(StructuredQName qName) {
        XSLVariableDeclaration decl = this.bindLocalVariable(qName);
        if (decl != null) {
            return decl;
        }
        return this.getPrincipalStylesheetModule().getGlobalVariable(qName);
    }

    public XSLVariableDeclaration bindLocalVariable(StructuredQName qName) {
        block4: {
            NodeInfo curr = this;
            NodeInfo prev = this;
            if (!this.isTopLevel()) {
                XSLVariableDeclaration var;
                AxisIterator preceding = curr.iterateAxis((byte)11);
                do {
                    curr = (NodeInfo)preceding.next();
                    while (curr == null) {
                        curr = prev.getParent();
                        while (curr instanceof StyleElement && !((StyleElement)curr).seesAvuncularVariables()) {
                            curr = curr.getParent();
                        }
                        prev = curr;
                        if (curr.getParent() instanceof XSLStylesheet) break;
                        preceding = curr.iterateAxis((byte)11);
                        curr = (NodeInfo)preceding.next();
                    }
                    if (curr.getParent() instanceof XSLStylesheet) break block4;
                } while (!(curr instanceof XSLVariableDeclaration) || !(var = (XSLVariableDeclaration)curr).getVariableQName().equals(qName));
                return var;
            }
        }
        return null;
    }

    protected boolean seesAvuncularVariables() {
        return true;
    }

    @Override
    public int getConstructType() {
        return this.getFingerprint();
    }

    @Override
    public StructuredQName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(StructuredQName qName) {
        this.objectName = qName;
    }

    @Override
    public Object getProperty(String name) {
        return this.getAttributeValue("", name);
    }

    @Override
    public Iterator getProperties() {
        NodeInfo a;
        NamePool pool = this.getNamePool();
        ArrayList<String> list = new ArrayList<String>(10);
        AxisIterator it = this.iterateAxis((byte)2);
        while ((a = (NodeInfo)it.next()) != null) {
            list.add(pool.getClarkName(a.getNameCode()));
        }
        return list.iterator();
    }

    @Override
    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    @Override
    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    @Override
    public int getColumnNumber(long locationId) {
        return this.getColumnNumber();
    }

    @Override
    public int getHostLanguage() {
        return 50;
    }

    public boolean isActionCompleted(int action) {
        return (this.actionsCompleted & action) != 0;
    }

    public void setActionCompleted(int action) {
        this.actionsCompleted |= action;
    }
}

