/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xmlresolver.CatalogResult;
import org.xmlresolver.ResourceCache;
import org.xmlresolver.helpers.DOMUtils;
import org.xmlresolver.helpers.PublicId;
import org.xmlresolver.helpers.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Catalog {
    public static final String NS_CATALOG = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final String NS_RDDL = "http://www.rddl.org/";
    public static final String NS_XLINK = "http://www.w3.org/1999/xlink";
    public static final String NS_XMLRESOURCE_EXT = "http://xmlresolver.org/ns/catalog";
    private static Logger logger = Logger.getLogger("org.xmlresolver");
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private String propertyFile = null;
    private URL propertyFileURI = null;
    private ResourceBundle resources = null;
    private Vector<String> catalogList = null;
    private Vector<Document> documentList = null;
    private ResourceCache cache = null;
    private int verbosity = 0;

    public Catalog() {
        String propfile = System.getProperty("xmlresolver.properties");
        if (propfile != null) {
            try {
                FileInputStream in = new FileInputStream(new File(propfile));
                if (in == null) {
                    logger.warning("Cannot find " + this.propertyFile);
                } else {
                    this.resources = new PropertyResourceBundle(in);
                    this.propertyFile = propfile;
                }
            }
            catch (MissingResourceException mre) {
                logger.warning("Cannot read resources in " + this.propertyFile);
            }
            catch (IOException e) {
                logger.warning("I/O error reading " + this.propertyFile);
            }
        }
        this.init("XMLResolver.properties;CatalogManager.properties", null);
    }

    public Catalog(String catalogList) {
        Vector<String> catalogFiles = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(catalogList, ";");
        while (tokens.hasMoreTokens()) {
            String catalogFile = tokens.nextToken();
            catalogFiles.add(catalogFile);
        }
        this.init("XMLResolver.properties;CatalogManager.properties", catalogFiles);
    }

    public Catalog(String propertyFileList, String catalogList) {
        Vector<String> catalogFiles = new Vector<String>();
        if (catalogList != null) {
            for (String catalogFile : catalogList.split(";")) {
                catalogFiles.add(catalogFile);
            }
        }
        this.init(propertyFileList, catalogFiles);
    }

    private Catalog(ResourceBundle resources, Vector<String> catalogFiles) {
        this.resources = resources;
        this.init(null, catalogFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String propertyFiles, Vector<String> catalogFiles) {
        Object fileList;
        if (propertyFiles != null) {
            fileList = propertyFiles.split(";");
            for (int pos = 0; pos < ((String[])fileList).length && this.propertyFile == null; ++pos) {
                if (!this.readProperties(fileList[pos])) continue;
                this.propertyFile = fileList[pos];
            }
        }
        this.setVerbosity(this.queryVerbosity());
        if (catalogFiles == null || catalogFiles.size() == 0) {
            catalogFiles = this.queryCatalogFiles();
        }
        this.catalogList = catalogFiles;
        this.documentList = new Vector();
        fileList = factory;
        synchronized (fileList) {
            factory.setNamespaceAware(true);
        }
        String cacheDir = this.queryCache();
        if (cacheDir != null) {
            this.cache = new ResourceCache(cacheDir);
        }
    }

    private synchronized boolean readProperties(String propertyFile) {
        try {
            this.propertyFileURI = Catalog.class.getResource("/" + propertyFile);
            InputStream in = Catalog.class.getResourceAsStream("/" + propertyFile);
            if (in == null) {
                logger.warning("Cannot find " + propertyFile);
                return false;
            }
            this.resources = new PropertyResourceBundle(in);
        }
        catch (MissingResourceException mre) {
            logger.warning("Cannot read resources in " + propertyFile);
            return false;
        }
        catch (IOException e) {
            logger.warning("I/O error reading " + propertyFile);
            return false;
        }
        return true;
    }

    private String queryCache() {
        String home;
        String cacheDir = System.getProperty("xml.catalog.cache");
        if (cacheDir == null && this.resources != null) {
            try {
                cacheDir = this.resources.getString("cache");
            }
            catch (MissingResourceException e) {
                cacheDir = null;
            }
        }
        if (cacheDir == null && (home = System.getProperty("user.home")) != null && !"".equals(home)) {
            String dir = home + "/.xmlresolver/cache";
            File fDir = new File(dir);
            if (!fDir.exists()) {
                fDir.mkdirs();
            }
            if (!fDir.exists() || !fDir.isDirectory()) {
                logger.warning("Could not create default cache directory: " + dir);
            } else {
                cacheDir = dir;
            }
        }
        return cacheDir;
    }

    private int queryVerbosity() {
        String verb = System.getProperty("xml.catalog.verbosity");
        if (verb == null && this.resources != null) {
            try {
                verb = this.resources.getString("verbosity");
            }
            catch (MissingResourceException e) {
                verb = null;
            }
        }
        return this.convertVerbosityString(verb);
    }

    private int convertVerbosityString(String verb) {
        int v = this.verbosity;
        if (verb == null) {
            return v;
        }
        if (verb.equalsIgnoreCase("severe")) {
            v = 1;
        } else if (verb.equalsIgnoreCase("warning") || verb.equalsIgnoreCase("warn")) {
            v = 2;
        } else if (verb.equalsIgnoreCase("info")) {
            v = 3;
        } else if (verb.equalsIgnoreCase("config")) {
            v = 4;
        } else if (verb.equalsIgnoreCase("fine")) {
            v = 5;
        } else if (verb.equalsIgnoreCase("finer")) {
            v = 6;
        } else if (verb.equalsIgnoreCase("finest")) {
            v = 7;
        } else if (verb.equalsIgnoreCase("all")) {
            v = 8;
        } else if (verb.equalsIgnoreCase("off")) {
            v = 0;
        } else {
            try {
                v = Integer.parseInt(verb);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return v;
    }

    private Vector<String> queryCatalogFiles() {
        String catalogList = System.getProperty("xml.catalog.files");
        boolean fromPropertiesFile = false;
        boolean relativeCatalogs = true;
        if (this.resources != null) {
            if (catalogList == null) {
                try {
                    catalogList = this.resources.getString("catalogs");
                    fromPropertiesFile = true;
                }
                catch (MissingResourceException e) {
                    catalogList = null;
                }
            }
            try {
                String allow = this.resources.getString("relative-catalogs");
                relativeCatalogs = allow.equalsIgnoreCase("true") || allow.equalsIgnoreCase("yes") || allow.equalsIgnoreCase("1");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (catalogList == null) {
            catalogList = "./catalog.xml";
        }
        Vector<String> catalogFiles = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(catalogList, ";");
        while (tokens.hasMoreTokens()) {
            String catalogFile = tokens.nextToken();
            URL absURI = null;
            if (fromPropertiesFile && !relativeCatalogs) {
                try {
                    absURI = new URL(this.propertyFileURI, catalogFile);
                    catalogFile = absURI.toString();
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
            }
            catalogFiles.add(catalogFile);
        }
        return catalogFiles;
    }

    private boolean queryPreferPublic() {
        String prefer = System.getProperty("xml.catalog.prefer");
        if (prefer == null) {
            if (this.resources != null) {
                try {
                    prefer = this.resources.getString("prefer");
                }
                catch (MissingResourceException e) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return "public".equalsIgnoreCase(prefer);
    }

    public String catalogList() {
        String list = "";
        for (String catalog : this.catalogList) {
            if (list.length() > 0) {
                list = list + ";";
            }
            list = list + catalog;
        }
        return list;
    }

    public ResourceCache cache() {
        return this.cache;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
        switch (verbosity) {
            case 0: {
                logger.setLevel(Level.OFF);
                break;
            }
            case 1: {
                logger.setLevel(Level.SEVERE);
                break;
            }
            case 2: {
                logger.setLevel(Level.WARNING);
                break;
            }
            case 3: {
                logger.setLevel(Level.INFO);
                break;
            }
            case 4: {
                logger.setLevel(Level.CONFIG);
                break;
            }
            case 5: {
                logger.setLevel(Level.FINE);
                break;
            }
            case 6: {
                logger.setLevel(Level.FINER);
                break;
            }
            case 7: {
                logger.setLevel(Level.FINEST);
                break;
            }
            default: {
                logger.setLevel(Level.ALL);
            }
        }
    }

    public void setVerbosity(String verbosity) {
        this.setVerbosity(this.convertVerbosityString(verbosity));
    }

    public boolean cacheSchemeURI(String scheme) {
        if (scheme == null) {
            return false;
        }
        String prop = System.getProperty("xml.catalog.cache." + scheme);
        if (prop == null) {
            if (this.resources != null) {
                try {
                    prop = this.resources.getString("cache-" + scheme + "-uri");
                }
                catch (MissingResourceException e) {
                    return !"file".equals(scheme);
                }
            } else {
                return !"file".equals(scheme);
            }
        }
        return prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("yes") || prop.equalsIgnoreCase("1");
    }

    private synchronized Document loadCatalog(int index) {
        Element root;
        if (index < this.documentList.size()) {
            return this.documentList.get(index);
        }
        String catalog = this.catalogList.get(index);
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = factory.newDocumentBuilder();
            doc = builder.parse(catalog);
        }
        catch (ParserConfigurationException pce) {
            logger.warning("Parser configuration exception attempting to load " + catalog);
            return null;
        }
        catch (FileNotFoundException fnfe) {
            logger.finer("Catalog file not found: " + catalog);
        }
        catch (IOException ex) {
            logger.warning("I/O exception reading " + catalog + ": " + ex.toString());
        }
        catch (SAXException ex) {
            logger.warning("SAX exception reading " + catalog + ": " + ex.toString());
        }
        while (this.documentList.size() <= index) {
            this.documentList.add(null);
        }
        this.documentList.set(index, doc);
        int offset = 1;
        if (doc != null && this.catalogElement(root = doc.getDocumentElement(), "catalog")) {
            Element child = DOMUtils.getFirstElement(root);
            while (child != null) {
                if (this.catalogElement(child, "nextCatalog")) {
                    Element nextCat = child;
                    String nextCatalog = DOMUtils.makeAbsolute(nextCat, nextCat.getAttribute("catalog"));
                    logger.finer("Next catalog: " + nextCat.getAttribute("catalog") + " (" + nextCatalog + ")");
                    if (index + offset >= this.catalogList.size()) {
                        this.catalogList.add(nextCatalog);
                    } else {
                        this.catalogList.insertElementAt(nextCatalog, index + offset);
                    }
                    ++offset;
                }
                child = DOMUtils.getNextElement(child);
            }
        }
        return doc;
    }

    private boolean catalogElement(Node node, String localName) {
        return node.getNodeType() == 1 && localName.equals(node.getLocalName()) && NS_CATALOG.equals(node.getNamespaceURI());
    }

    private Vector<Element> entries(Element group, String entry) {
        Vector<Element> matchingEntries = new Vector<Element>();
        this.findMatches(matchingEntries, group, entry, null, null, null, null);
        return matchingEntries;
    }

    private Vector<Element> entries(Element group, String entry, String attr, String value, String nature, String purpose) {
        Vector<Element> matchingEntries = new Vector<Element>();
        this.findMatches(matchingEntries, group, entry, attr, value, nature, purpose);
        return matchingEntries;
    }

    private void findMatches(Vector<Element> matching, Element group, String entry, String attr, String value, String nature, String purpose) {
        if (this.catalogElement(group, "group") || this.catalogElement(group, "catalog")) {
            Element child = DOMUtils.getFirstElement(group);
            while (child != null) {
                if (this.catalogElement(child, entry) && (attr == null || value.equals(child.getAttribute(attr)))) {
                    String uriPurpose;
                    String uriNature = child.hasAttributeNS(NS_RDDL, "nature") ? child.getAttributeNS(NS_RDDL, "nature") : null;
                    String string = uriPurpose = child.hasAttributeNS(NS_RDDL, "purpose") ? child.getAttributeNS(NS_RDDL, "purpose") : null;
                    if ((nature == null || nature.equals(uriNature)) && (purpose == null || purpose.equals(uriPurpose))) {
                        matching.add(child);
                    }
                }
                if (this.catalogElement(child, "group")) {
                    this.findMatches(matching, child, entry, attr, value, nature, purpose);
                }
                child = DOMUtils.getNextElement(child);
            }
        }
    }

    public CatalogResult lookupURI(String uri) {
        logger.fine("lookupURI(" + uri + ")");
        return this._lookupNamespaceURI(uri, null, null);
    }

    public CatalogResult lookupNamespaceURI(String uri, String nature, String purpose) {
        logger.fine("lookupNamespaceURI(" + uri + "," + nature + "," + purpose + ")");
        return this._lookupNamespaceURI(uri, nature, purpose);
    }

    private CatalogResult _lookupNamespaceURI(String uri, String nature, String purpose) {
        if (uri == null) {
            throw new NullPointerException("Null uri passed to Catalog.");
        }
        if ((uri = URIUtils.normalizeURI(uri)).startsWith("urn:publicid:")) {
            return this.lookupPublic(PublicId.decodeURN(uri), null);
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupURI(doc.getDocumentElement(), uri, nature, purpose);
            if (resolved == null) continue;
            logger.fine("  Found: " + resolved);
            return resolved;
        }
        if (this.cache != null && this.cache.catalog() != null) {
            logger.finer("  Looking in " + this.cache.catalog().getBaseURI());
            CatalogResult resolved = this.lookupURI(this.cache.catalog().getDocumentElement(), uri, nature, purpose);
            if (resolved != null) {
                logger.fine("  Found: " + resolved);
                return resolved;
            }
        }
        logger.fine("  Not found");
        return null;
    }

    protected CatalogResult lookupURI(Element group, String uri, String nature, String purpose) {
        Iterator<Element> i$ = this.entries(group, "uri", "name", uri, nature, purpose).iterator();
        if (i$.hasNext()) {
            Element child = i$.next();
            String entry_uri = child.getAttribute("uri");
            String entry_redir = child.getAttributeNS(NS_XMLRESOURCE_EXT, "redir");
            return new CatalogResult(entry_redir == null ? entry_uri : entry_redir, DOMUtils.makeAbsolute(child, entry_uri), child, this.cache);
        }
        String startString = null;
        Element node = null;
        for (Element child : this.entries(group, "rewriteURI", null, uri, nature, purpose)) {
            String p = child.getAttribute("uriStartString");
            if (p.length() > uri.length() || !p.equals(uri.substring(0, p.length())) || startString != null && p.length() <= startString.length()) continue;
            startString = p;
            node = child;
        }
        if (node != null) {
            return new CatalogResult(uri, DOMUtils.makeAbsolute(node, node.getAttribute("rewritePrefix") + uri.substring(startString.length())), node, this.cache);
        }
        String suffixString = null;
        node = null;
        for (Element child : this.entries(group, "uriSuffix", null, uri, nature, purpose)) {
            String p = child.getAttribute("uriSuffix");
            if (p.length() > uri.length() || !uri.endsWith(p) || suffixString != null && p.length() <= suffixString.length()) continue;
            suffixString = p;
            node = child;
        }
        if (node != null) {
            return new CatalogResult(uri, DOMUtils.makeAbsolute(node, node.getAttribute("uri")), node, this.cache);
        }
        Vector<String> delegated = new Vector<String>();
        for (Element child : this.entries(group, "delegateURI", null, uri, nature, purpose)) {
            String p = child.getAttribute("uriStartString");
            if (p.length() > uri.length() || !p.equals(uri.substring(0, p.length()))) continue;
            delegated.add(DOMUtils.makeAbsolute(child, child.getAttribute("catalog")));
        }
        if (!delegated.isEmpty()) {
            Catalog dResolver = new Catalog(this.resources, delegated);
            CatalogResult resolved = null;
            resolved = nature != null || purpose != null ? dResolver.lookupNamespaceURI(uri, nature, purpose) : dResolver.lookupURI(uri);
            return resolved;
        }
        return null;
    }

    public CatalogResult lookupPublic(String systemId, String publicId) {
        logger.fine("lookupPublic(" + systemId + "," + publicId + ")");
        if (systemId != null) {
            systemId = URIUtils.normalizeURI(systemId);
        }
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupPublic(doc.getDocumentElement(), systemId, publicId);
            if (resolved == null) continue;
            logger.fine("  Found: " + resolved);
            return resolved;
        }
        if (this.cache != null && this.cache.catalog() != null) {
            logger.finer("  Looking in " + this.cache.catalog().getBaseURI());
            CatalogResult resolved = this.lookupPublic(this.cache.catalog().getDocumentElement(), systemId, publicId);
            if (resolved != null) {
                logger.fine("  Found: " + resolved);
                return resolved;
            }
        }
        logger.fine("  Not found");
        return null;
    }

    protected CatalogResult lookupPublic(Element group, String systemId, String publicId) {
        if (this.catalogElement(group, "group") || this.catalogElement(group, "catalog")) {
            CatalogResult resolved;
            if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
                return resolved;
            }
            if (publicId != null && (resolved = this.lookupLocalPublic(group, systemId, publicId)) != null) {
                return resolved;
            }
        }
        return null;
    }

    protected CatalogResult lookupLocalPublic(Element group, String systemId, String publicId) {
        CatalogResult resolved;
        publicId = PublicId.normalize(publicId);
        if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
            return resolved;
        }
        for (Element child : this.entries(group, "public", "publicId", publicId, null, null)) {
            boolean preferpublic = this.queryPreferPublic();
            Node node = child;
            while (node != null && node.getNodeType() == 1) {
                Element p = node;
                if (p.hasAttribute("prefer")) {
                    preferpublic = "public".equals(p.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!preferpublic && systemId != null) continue;
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            String origURI = systemId;
            if (origURI == null) {
                origURI = localURI;
            }
            return new CatalogResult(origURI, localURI, child, this.cache);
        }
        Vector<String> delegated = new Vector<String>();
        for (Element child : this.entries(group, "delegatePublic", null, null, null, null)) {
            String p = child.getAttribute("publicIdStartString");
            if (p.length() > systemId.length() || !p.equals(systemId.substring(0, p.length()))) continue;
            delegated.add(DOMUtils.makeAbsolute(child, child.getAttribute("catalog")));
        }
        if (!delegated.isEmpty()) {
            Catalog dResolver = new Catalog(this.resources, delegated);
            CatalogResult resolved2 = dResolver.lookupSystem(systemId);
            return resolved2;
        }
        return null;
    }

    public CatalogResult lookupSystem(String systemId) {
        logger.fine("lookupSystem(" + systemId + ")");
        systemId = URIUtils.normalizeURI(systemId);
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            return this.lookupPublic(PublicId.decodeURN(systemId), null);
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupLocalSystem(doc.getDocumentElement(), systemId);
            if (resolved == null) continue;
            logger.fine("  Found: " + resolved);
            return resolved;
        }
        if (this.cache != null && this.cache.catalog() != null) {
            logger.finer("  Looking in " + this.cache.catalog().getBaseURI());
            CatalogResult resolved = this.lookupLocalSystem(this.cache.catalog().getDocumentElement(), systemId);
            if (resolved != null) {
                logger.fine("  Found: " + resolved);
                return resolved;
            }
        }
        logger.fine("  Not found");
        return null;
    }

    protected CatalogResult lookupLocalSystem(Element group, String systemId) {
        String osname = System.getProperty("os.name");
        boolean windows = osname.indexOf("Windows") >= 0;
        for (Element child : this.entries(group, "system", null, null, null, null)) {
            if (!systemId.equals(child.getAttribute("systemId")) && (!windows || !systemId.equalsIgnoreCase(child.getAttribute("systemId")))) continue;
            return new CatalogResult(systemId, DOMUtils.makeAbsolute(child, child.getAttribute("uri")), child, this.cache);
        }
        String startString = null;
        Element node = null;
        for (Element child : this.entries(group, "rewriteSystem", null, null, null, null)) {
            String p = child.getAttribute("uriStartString");
            if (p.length() > systemId.length() || !p.equals(systemId.substring(0, p.length())) || startString != null && p.length() <= startString.length()) continue;
            startString = p;
            node = child;
        }
        if (node != null) {
            return new CatalogResult(systemId, DOMUtils.makeAbsolute(node, node.getAttribute("rewritePrefix") + systemId.substring(startString.length())), node, this.cache);
        }
        String suffixString = null;
        node = null;
        for (Element child : this.entries(group, "systemSuffix", null, null, null, null)) {
            String p = child.getAttribute("systemIdSuffix");
            if (p.length() > systemId.length() || !systemId.endsWith(p) || suffixString != null && p.length() <= suffixString.length()) continue;
            suffixString = p;
            node = child;
        }
        if (node != null) {
            return new CatalogResult(systemId, DOMUtils.makeAbsolute(node, node.getAttribute("uri")), node, this.cache);
        }
        Vector<String> delegated = new Vector<String>();
        for (Element child : this.entries(group, "delegateSystem", null, null, null, null)) {
            String p = child.getAttribute("systemIdStartString");
            if (p.length() > systemId.length() || !p.equals(systemId.substring(0, p.length()))) continue;
            delegated.add(DOMUtils.makeAbsolute(child, child.getAttribute("catalog")));
        }
        if (!delegated.isEmpty()) {
            Catalog dResolver = new Catalog(this.resources, delegated);
            CatalogResult resolved = dResolver.lookupSystem(systemId);
            return resolved;
        }
        return null;
    }

    public CatalogResult lookupDoctype(String entityName, String systemId, String publicId) {
        logger.fine("lookupDoctype(" + entityName + "," + publicId + "," + systemId + ")");
        systemId = URIUtils.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupDoctype(doc.getDocumentElement(), entityName, systemId, publicId);
            if (resolved == null) continue;
            logger.fine("  Found: " + resolved);
            return resolved;
        }
        logger.fine("  Not found");
        return null;
    }

    protected CatalogResult lookupDoctype(Element group, String entityName, String systemId, String publicId) {
        CatalogResult resolved = null;
        if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.lookupLocalPublic(group, systemId, publicId)) != null) {
            return resolved;
        }
        for (Element child : this.entries(group, "doctype", "name", entityName, null, null)) {
            boolean preferpublic = this.queryPreferPublic();
            Node node = child;
            while (node != null && node.getNodeType() == 1) {
                Element p = node;
                if (p.hasAttribute("prefer")) {
                    preferpublic = "public".equals(p.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!preferpublic && systemId != null) continue;
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            String origURI = systemId;
            if (origURI == null) {
                origURI = localURI;
            }
            return new CatalogResult(origURI, localURI, child, this.cache);
        }
        return null;
    }

    public CatalogResult lookupDocument() {
        logger.fine("lookupDocument()");
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupDocument(doc.getDocumentElement());
            if (resolved == null) continue;
            logger.fine("  Found: " + resolved);
            return resolved;
        }
        logger.fine("  Not found");
        return null;
    }

    protected CatalogResult lookupDocument(Element group) {
        Iterator<Element> i$ = this.entries(group, "document", null, null, null, null).iterator();
        if (i$.hasNext()) {
            Element child = i$.next();
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            return new CatalogResult(localURI, localURI, child, this.cache);
        }
        return null;
    }

    public CatalogResult lookupEntity(String entityName, String systemId, String publicId) {
        logger.fine("lookupEntity(" + entityName + "," + publicId + "," + systemId + ")");
        systemId = URIUtils.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupEntity(doc.getDocumentElement(), entityName, systemId, publicId);
            if (resolved == null) continue;
            logger.fine("  Found: " + resolved);
            return resolved;
        }
        logger.fine("  Not found");
        return null;
    }

    protected CatalogResult lookupEntity(Element group, String entityName, String systemId, String publicId) {
        CatalogResult resolved = null;
        if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.lookupLocalPublic(group, systemId, publicId)) != null) {
            return resolved;
        }
        for (Element child : this.entries(group, "entity", "name", entityName, null, null)) {
            boolean preferpublic = this.queryPreferPublic();
            Node node = child;
            while (node != null && node.getNodeType() == 1) {
                Element p = node;
                if (p.hasAttribute("prefer")) {
                    preferpublic = "public".equals(p.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!preferpublic && systemId != null) continue;
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            String origURI = systemId;
            if (origURI == null) {
                origURI = localURI;
            }
            return new CatalogResult(origURI, localURI, child, this.cache);
        }
        return null;
    }

    public CatalogResult lookupNotation(String notName, String systemId, String publicId) {
        logger.fine("lookupNotation(" + notName + "," + publicId + "," + systemId + ")");
        systemId = URIUtils.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        for (int index = 0; index < this.catalogList.size(); ++index) {
            this.loadCatalog(index);
            Document doc = this.documentList.get(index);
            if (doc == null) continue;
            logger.finer("  Looking in " + doc.getBaseURI());
            CatalogResult resolved = this.lookupNotation(doc.getDocumentElement(), notName, systemId, publicId);
            if (resolved == null) continue;
            logger.fine("  Found: " + resolved);
            return resolved;
        }
        logger.fine("  Not found");
        return null;
    }

    protected CatalogResult lookupNotation(Element group, String notName, String systemId, String publicId) {
        CatalogResult resolved = null;
        if (systemId != null && (resolved = this.lookupLocalSystem(group, systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.lookupLocalPublic(group, systemId, publicId)) != null) {
            return resolved;
        }
        for (Element child : this.entries(group, "notation", "name", notName, null, null)) {
            boolean preferpublic = this.queryPreferPublic();
            Node node = child;
            while (node != null && node.getNodeType() == 1) {
                Element p = node;
                if (p.hasAttribute("prefer")) {
                    preferpublic = "public".equals(p.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!preferpublic && systemId != null) continue;
            String localURI = DOMUtils.makeAbsolute(child, child.getAttribute("uri"));
            String origURI = systemId;
            if (origURI == null) {
                origURI = localURI;
            }
            return new CatalogResult(origURI, localURI, child, this.cache);
        }
        return null;
    }
}

