/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public final class KeyPattern
extends NodeSetPattern {
    private StructuredQName keyName;
    private KeyDefinitionSet keySet;

    public KeyPattern(StructuredQName keyName, Expression key, Configuration config) {
        super(key, config);
        this.keyName = keyName;
    }

    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.expression = visitor.typeCheck(this.expression, contextItemType);
        RoleLocator role = new RoleLocator(0, (Serializable)((Object)"key"), 2);
        this.expression = TypeChecker.staticTypeCheck(this.expression, SequenceType.ATOMIC_SEQUENCE, false, role, visitor);
        this.keySet = visitor.getExecutable().getKeyManager().getKeyDefinitionSet(this.keyName);
        if (this.keySet == null) {
            XPathException err = new XPathException("Unknown key name " + this.keyName.getClarkName() + " in pattern");
            err.setErrorCode("XTDE1260");
            err.setLocator(this);
            err.setIsStaticError(true);
            throw err;
        }
        return this;
    }

    public boolean matches(NodeInfo e, XPathContext context) throws XPathException {
        DocumentInfo doc;
        KeyDefinitionSet kds = this.keySet;
        if (kds == null) {
            kds = context.getController().getExecutable().getKeyManager().getKeyDefinitionSet(this.keyName);
        }
        if ((doc = e.getDocumentRoot()) == null) {
            return false;
        }
        KeyManager km = context.getController().getKeyManager();
        SequenceIterator iter = this.expression.iterate(context);
        block0: while (true) {
            NodeInfo n;
            Item it;
            if ((it = iter.next()) == null) {
                return false;
            }
            SequenceIterator nodes = km.selectByKey(kds, doc, (AtomicValue)it, context);
            do {
                if ((n = (NodeInfo)nodes.next()) == null) continue block0;
            } while (!n.isSameNodeInfo(e));
            break;
        }
        return true;
    }

    public NodeTest getNodeTest() {
        return AnyNodeTest.getInstance();
    }
}

