/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.tree.tiny.TinyTree;

public class TinyAttributeCollection
implements AttributeCollection {
    int element;
    TinyTree tree;
    int firstAttribute;

    public TinyAttributeCollection(TinyTree tree, int element) {
        this.tree = tree;
        this.element = element;
        this.firstAttribute = tree.alpha[element];
    }

    public void setLocationProvider(LocationProvider provider) {
    }

    public int getLength() {
        int i;
        for (i = this.firstAttribute; i < this.tree.numberOfAttributes && this.tree.attParent[i] == this.element; ++i) {
        }
        return i - this.firstAttribute;
    }

    public int getNameCode(int index) {
        return this.tree.attCode[this.firstAttribute + index];
    }

    public int getTypeAnnotation(int index) {
        if (this.tree.attTypeCode == null) {
            return 631;
        }
        return this.tree.attTypeCode[this.firstAttribute + index];
    }

    public int getLocationId(int index) {
        return 0;
    }

    public String getSystemId(int index) {
        return this.tree.getSystemId(this.element);
    }

    public int getLineNumber(int index) {
        return -1;
    }

    public int getProperties(int index) {
        return 0;
    }

    public String getPrefix(int index) {
        return this.tree.getNamePool().getPrefix(this.getNameCode(index));
    }

    public String getQName(int index) {
        return this.tree.getNamePool().getDisplayName(this.getNameCode(index));
    }

    public String getLocalName(int index) {
        return this.tree.getNamePool().getLocalName(this.getNameCode(index));
    }

    public String getURI(int index) {
        return this.tree.getNamePool().getURI(this.getNameCode(index));
    }

    public int getIndex(String uri, String localname) {
        int fingerprint = this.tree.getNamePool().getFingerprint(uri, localname);
        return this.getIndexByFingerprint(fingerprint);
    }

    public int getIndexByFingerprint(int fingerprint) {
        int i = this.firstAttribute;
        while (this.tree.attParent[i] == this.element) {
            if ((this.tree.attCode[i] & 0xFFFFF) == fingerprint) {
                return i - this.firstAttribute;
            }
            ++i;
        }
        return -1;
    }

    public String getValueByFingerprint(int fingerprint) {
        return this.getValue(this.getIndexByFingerprint(fingerprint));
    }

    public String getValue(String uri, String localname) {
        return this.getValue(this.getIndex(uri, localname));
    }

    public String getValue(int index) {
        CharSequence cs = this.tree.attValue[this.firstAttribute + index];
        return cs == null ? null : ((Object)cs).toString();
    }

    public boolean isId(int index) {
        return (this.getTypeAnnotation(index) & 0xFFFFF) == 560 || (this.getNameCode(index) & 0xFFFFF) == 388;
    }

    public boolean isIdref(int index) {
        return (this.getTypeAnnotation(index) & 0xFFFFF) == 561 || (this.getTypeAnnotation(index) & 0xFFFFF) == 562;
    }
}

