/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelReader
extends IndexReader {
    private List<IndexReader> readers = new ArrayList<IndexReader>();
    private List<Boolean> decrefOnClose = new ArrayList<Boolean>();
    boolean incRefReaders = false;
    private SortedMap<String, IndexReader> fieldToReader = new TreeMap<String, IndexReader>();
    private Map<IndexReader, Collection<String>> readerToFields = new HashMap<IndexReader, Collection<String>>();
    private List<IndexReader> storedFieldReaders = new ArrayList<IndexReader>();
    private int maxDoc;
    private int numDocs;
    private boolean hasDeletions;

    public ParallelReader() throws IOException {
        this(true);
    }

    public ParallelReader(boolean closeSubReaders) throws IOException {
        this.incRefReaders = !closeSubReaders;
    }

    public void add(IndexReader reader) throws IOException {
        this.ensureOpen();
        this.add(reader, false);
    }

    public void add(IndexReader reader, boolean ignoreStoredFields) throws IOException {
        this.ensureOpen();
        if (this.readers.size() == 0) {
            this.maxDoc = reader.maxDoc();
            this.numDocs = reader.numDocs();
            this.hasDeletions = reader.hasDeletions();
        }
        if (reader.maxDoc() != this.maxDoc) {
            throw new IllegalArgumentException("All readers must have same maxDoc: " + this.maxDoc + "!=" + reader.maxDoc());
        }
        if (reader.numDocs() != this.numDocs) {
            throw new IllegalArgumentException("All readers must have same numDocs: " + this.numDocs + "!=" + reader.numDocs());
        }
        Collection<String> fields = reader.getFieldNames(IndexReader.FieldOption.ALL);
        this.readerToFields.put(reader, fields);
        for (String field : fields) {
            if (this.fieldToReader.get(field) != null) continue;
            this.fieldToReader.put(field, reader);
        }
        if (!ignoreStoredFields) {
            this.storedFieldReaders.add(reader);
        }
        this.readers.add(reader);
        if (this.incRefReaders) {
            reader.incRef();
        }
        this.decrefOnClose.add(this.incRefReaders);
    }

    @Override
    public synchronized Object clone() {
        try {
            return this.doReopen(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        return this.doReopen(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected IndexReader doReopen(boolean doClone) throws CorruptIndexException, IOException {
        this.ensureOpen();
        reopened = false;
        newReaders = new ArrayList<IndexReader>();
        success = false;
        try {
            for (IndexReader oldReader : this.readers) {
                newReader = null;
                newReader = doClone != false ? (IndexReader)oldReader.clone() : oldReader.reopen();
                newReaders.add(newReader);
                if (newReader == oldReader) continue;
                reopened = true;
            }
            success = true;
            var9_9 = null;
            ** if (success || !reopened) goto lbl-1000
        }
        catch (Throwable var8_17) {
            var9_10 = null;
            if (!success && reopened) {
                for (i = 0; i < newReaders.size(); ++i) {
                    r = (IndexReader)newReaders.get(i);
                    if (r == this.readers.get(i)) continue;
                    try {
                        r.close();
                        continue;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
            }
            throw var8_17;
        }
lbl-1000:
        // 4 sources

        {
            for (i = 0; i < newReaders.size(); ++i) {
                r = (IndexReader)newReaders.get(i);
                if (r == this.readers.get(i)) continue;
                try {
                    r.close();
                    continue;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (reopened) {
            newDecrefOnClose = new ArrayList<Boolean>();
            pr = new ParallelReader();
            for (i = 0; i < this.readers.size(); ++i) {
                oldReader = this.readers.get(i);
                newReader = (IndexReader)newReaders.get(i);
                if (newReader == oldReader) {
                    newDecrefOnClose.add(Boolean.TRUE);
                    newReader.incRef();
                } else {
                    newDecrefOnClose.add(Boolean.FALSE);
                }
                pr.add(newReader, this.storedFieldReaders.contains(oldReader) == false);
            }
            pr.decrefOnClose = newDecrefOnClose;
            pr.incRefReaders = this.incRefReaders;
            return pr;
        }
        return this;
    }

    @Override
    public int numDocs() {
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    @Override
    public boolean isDeleted(int n) {
        if (this.readers.size() > 0) {
            return this.readers.get(0).isDeleted(n);
        }
        return false;
    }

    @Override
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        for (IndexReader reader : this.readers) {
            reader.deleteDocument(n);
        }
        this.hasDeletions = true;
    }

    @Override
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (IndexReader reader : this.readers) {
            reader.undeleteAll();
        }
        this.hasDeletions = false;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        Document result = new Document();
        for (IndexReader reader : this.storedFieldReaders) {
            Collection<String> fields;
            boolean include;
            boolean bl = include = fieldSelector == null;
            if (!include) {
                fields = this.readerToFields.get(reader);
                for (String string : fields) {
                    if (fieldSelector.accept(string) == FieldSelectorResult.NO_LOAD) continue;
                    include = true;
                    break;
                }
            }
            if (!include) continue;
            fields = reader.document(n, fieldSelector).getFields();
            for (Fieldable fieldable : fields) {
                result.add(fieldable);
            }
        }
        return result;
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        ArrayList<TermFreqVector> results = new ArrayList<TermFreqVector>();
        for (Map.Entry<String, IndexReader> e : this.fieldToReader.entrySet()) {
            String field = e.getKey();
            IndexReader reader = e.getValue();
            TermFreqVector vector = reader.getTermFreqVector(n, field);
            if (vector == null) continue;
            results.add(vector);
        }
        return results.toArray(new TermFreqVector[results.size()]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getTermFreqVector(n, field);
    }

    @Override
    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.getTermFreqVector(docNumber, field, mapper);
        }
    }

    @Override
    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        for (Map.Entry<String, IndexReader> e : this.fieldToReader.entrySet()) {
            String field = e.getKey();
            IndexReader reader = e.getValue();
            reader.getTermFreqVector(docNumber, field, mapper);
        }
    }

    @Override
    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? false : reader.hasNorms(field);
    }

    @Override
    public byte[] norms(String field) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.norms(field);
    }

    @Override
    public void norms(String field, byte[] result, int offset) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.norms(field, result, offset);
        }
    }

    @Override
    protected void doSetNorm(int n, String field, byte value) throws CorruptIndexException, IOException {
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.doSetNorm(n, field, value);
        }
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new ParallelTermEnum();
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermEnum(term);
    }

    @Override
    public int docFreq(Term term) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(term.field());
        return reader == null ? 0 : reader.docFreq(term);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermDocs(term);
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new ParallelTermDocs();
    }

    @Override
    public TermPositions termPositions(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermPositions(term);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new ParallelTermPositions();
    }

    @Override
    public boolean isCurrent() throws CorruptIndexException, IOException {
        for (IndexReader reader : this.readers) {
            if (reader.isCurrent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOptimized() {
        for (IndexReader reader : this.readers) {
            if (reader.isOptimized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getVersion() {
        throw new UnsupportedOperationException("ParallelReader does not support this method.");
    }

    IndexReader[] getSubReaders() {
        return this.readers.toArray(new IndexReader[this.readers.size()]);
    }

    @Override
    protected void doCommit(Map<String, String> commitUserData) throws IOException {
        for (IndexReader reader : this.readers) {
            reader.commit(commitUserData);
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            if (this.decrefOnClose.get(i).booleanValue()) {
                this.readers.get(i).decRef();
                continue;
            }
            this.readers.get(i).close();
        }
    }

    @Override
    public Collection<String> getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        HashSet<String> fieldSet = new HashSet<String>();
        for (IndexReader reader : this.readers) {
            Collection<String> names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    private class ParallelTermPositions
    extends ParallelTermDocs
    implements TermPositions {
        public ParallelTermPositions() {
        }

        public ParallelTermPositions(Term term) throws IOException {
            this.seek(term);
        }

        public void seek(Term term) throws IOException {
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = reader != null ? reader.termPositions(term) : null;
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.termDocs).nextPosition();
        }

        public int getPayloadLength() {
            return ((TermPositions)this.termDocs).getPayloadLength();
        }

        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return ((TermPositions)this.termDocs).getPayload(data, offset);
        }

        public boolean isPayloadAvailable() {
            return ((TermPositions)this.termDocs).isPayloadAvailable();
        }
    }

    private class ParallelTermDocs
    implements TermDocs {
        protected TermDocs termDocs;

        public ParallelTermDocs() {
        }

        public ParallelTermDocs(Term term) throws IOException {
            if (term == null) {
                this.termDocs = ParallelReader.this.readers.isEmpty() ? null : ((IndexReader)ParallelReader.this.readers.get(0)).termDocs(null);
            } else {
                this.seek(term);
            }
        }

        public int doc() {
            return this.termDocs.doc();
        }

        public int freq() {
            return this.termDocs.freq();
        }

        public void seek(Term term) throws IOException {
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = reader != null ? reader.termDocs(term) : null;
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
        }

        public boolean next() throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.next();
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            if (this.termDocs == null) {
                return 0;
            }
            return this.termDocs.read(docs, freqs);
        }

        public boolean skipTo(int target) throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.skipTo(target);
        }

        public void close() throws IOException {
            if (this.termDocs != null) {
                this.termDocs.close();
            }
        }
    }

    private class ParallelTermEnum
    extends TermEnum {
        private String field;
        private Iterator<String> fieldIterator;
        private TermEnum termEnum;

        public ParallelTermEnum() throws IOException {
            try {
                this.field = (String)ParallelReader.this.fieldToReader.firstKey();
            }
            catch (NoSuchElementException e) {
                return;
            }
            if (this.field != null) {
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms();
            }
        }

        public ParallelTermEnum(Term term) throws IOException {
            this.field = term.field();
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(this.field);
            if (reader != null) {
                this.termEnum = reader.terms(term);
            }
        }

        public boolean next() throws IOException {
            if (this.termEnum == null) {
                return false;
            }
            if (this.termEnum.next() && this.termEnum.term().field() == this.field) {
                return true;
            }
            this.termEnum.close();
            if (this.fieldIterator == null) {
                this.fieldIterator = ParallelReader.this.fieldToReader.tailMap(this.field).keySet().iterator();
                this.fieldIterator.next();
            }
            while (this.fieldIterator.hasNext()) {
                this.field = this.fieldIterator.next();
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms(new Term(this.field));
                Term term = this.termEnum.term();
                if (term != null && term.field() == this.field) {
                    return true;
                }
                this.termEnum.close();
            }
            return false;
        }

        public Term term() {
            if (this.termEnum == null) {
                return null;
            }
            return this.termEnum.term();
        }

        public int docFreq() {
            if (this.termEnum == null) {
                return 0;
            }
            return this.termEnum.docFreq();
        }

        public void close() throws IOException {
            if (this.termEnum != null) {
                this.termEnum.close();
            }
        }
    }
}

