/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLText
extends StyleElement {
    private boolean disable = false;
    private String value = null;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.DISABLE_OUTPUT_ESCAPING) {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            if (string.equals("yes")) {
                this.disable = true;
            } else if (string.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        if (nodeImpl == null) {
            this.value = "";
        } else {
            this.value = nodeImpl.getStringValue();
            while (nodeImpl != null) {
                if (nodeImpl.getNodeType() == 1) {
                    this.compileError("xsl:text must not have any child elements");
                }
                nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
            }
        }
    }

    public void process(Context context) throws TransformerException {
        if (!this.value.equals("")) {
            Outputter outputter = context.getOutputter();
            if (this.disable) {
                outputter.setEscaping(false);
                outputter.writeContent(this.value);
                outputter.setEscaping(true);
            } else {
                outputter.writeContent(this.value);
            }
        }
    }
}

