/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.zip.GZIPInputStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;

public class StandardUnparsedTextResolver
implements UnparsedTextURIResolver {
    private boolean debug = false;

    public void setDebugging(boolean debug) {
        this.debug = debug;
    }

    public Reader resolve(URI absoluteURI, String encoding, Configuration config) throws XPathException {
        URL absoluteURL;
        PrintStream err = config.getStandardErrorOutput();
        if (this.debug) {
            err.println("unparsed-text(): processing " + absoluteURI);
            err.println("unparsed-text(): requested encoding = " + encoding);
        }
        try {
            absoluteURL = absoluteURI.toURL();
        }
        catch (MalformedURLException mue) {
            XPathException e = new XPathException("Cannot convert absolute URI to URL", mue);
            e.setErrorCode("XTDE1170");
            throw e;
        }
        try {
            URLConnection connection = absoluteURL.openConnection();
            connection.setRequestProperty("Accept-Encoding", "gzip");
            try {
                connection.connect();
            }
            catch (IOException ioe) {
                if (this.debug) {
                    err.println("unparsed-text(): connection failure. " + ioe.getMessage());
                }
                XPathException xpe = new XPathException("Failed to read input file", ioe);
                xpe.setErrorCode("XTDE1170");
                throw xpe;
            }
            InputStream is = connection.getInputStream();
            String contentEncoding = connection.getContentEncoding();
            if ("gzip".equals(contentEncoding)) {
                is = new GZIPInputStream(is);
            }
            if (this.debug) {
                err.println("unparsed-text(): established connection " + ("gzip".equals(contentEncoding) ? " (zipped)" : ""));
            }
            try {
                if (!is.markSupported()) {
                    is = new BufferedInputStream(is);
                }
                boolean isXmlMediaType = false;
                if (!"file".equals(connection.getURL().getProtocol())) {
                    String contentType = connection.getContentType();
                    if (this.debug) {
                        err.println("unparsed-text(): content type = " + contentType);
                    }
                    if (contentType != null) {
                        int pos = contentType.indexOf(59);
                        String mediaType = pos >= 0 ? contentType.substring(0, pos) : contentType;
                        mediaType = mediaType.trim();
                        if (this.debug) {
                            err.println("unparsed-text(): media type = " + mediaType);
                        }
                        isXmlMediaType = !(!mediaType.startsWith("application/") && !mediaType.startsWith("text/") || !mediaType.endsWith("/xml") && !mediaType.endsWith("+xml"));
                        String charset = "";
                        pos = contentType.toLowerCase().indexOf("charset");
                        if (pos >= 0) {
                            if ((pos = contentType.indexOf(61, pos + 7)) >= 0) {
                                charset = contentType.substring(pos + 1);
                            }
                            if ((pos = charset.indexOf(59)) > 0) {
                                charset = charset.substring(0, pos);
                            }
                            if ((pos = charset.indexOf(40)) > 0) {
                                charset = charset.substring(0, pos);
                            }
                            if ((pos = charset.indexOf(34)) > 0) {
                                charset = charset.substring(pos + 1, charset.indexOf(34, pos + 2));
                            }
                            if (this.debug) {
                                err.println("unparsed-text(): charset = " + charset.trim());
                            }
                            encoding = charset.trim();
                        }
                    }
                }
                if (encoding == null || isXmlMediaType) {
                    is.mark(100);
                    byte[] start = new byte[100];
                    int read = is.read(start, 0, 100);
                    is.reset();
                    encoding = this.inferEncoding(start, read, err);
                    if (this.debug) {
                        err.println("unparsed-text(): inferred encoding = " + encoding);
                    }
                }
            }
            catch (IOException e) {
                encoding = "UTF-8";
            }
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            decoder = decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder = decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            return new BufferedReader(new InputStreamReader(is, decoder));
        }
        catch (IOException ioe) {
            throw new XPathException(ioe);
        }
    }

    private String inferEncoding(byte[] start, int read, PrintStream err) {
        if (read >= 2) {
            if (this.ch(start[0]) == 254 && this.ch(start[1]) == 255) {
                if (this.debug) {
                    err.println("unparsed-text(): found UTF-16 byte order mark");
                }
                return "UTF-16";
            }
            if (this.ch(start[0]) == 255 && this.ch(start[1]) == 254) {
                if (this.debug) {
                    err.println("unparsed-text(): found UTF-16LE byte order mark");
                }
                return "UTF-16LE";
            }
        }
        if (read >= 3 && this.ch(start[0]) == 239 && this.ch(start[1]) == 187 && this.ch(start[2]) == 191) {
            if (this.debug) {
                err.println("unparsed-text(): found UTF-8 byte order mark");
            }
            return "UTF-8";
        }
        if (read >= 4) {
            if (this.ch(start[0]) == 60 && this.ch(start[1]) == 63 && this.ch(start[2]) == 120 && this.ch(start[3]) == 109 && this.ch(start[4]) == 108) {
                if (this.debug) {
                    err.println("unparsed-text(): found XML declaration");
                }
                FastStringBuffer sb = new FastStringBuffer(read);
                for (int b = 0; b < read; ++b) {
                    sb.append((char)start[b]);
                }
                String p = sb.toString();
                int v = p.indexOf("encoding");
                if (v >= 0) {
                    v += 8;
                    while (v < p.length() && " \n\r\t=\"'".indexOf(p.charAt(v)) >= 0) {
                        ++v;
                    }
                    sb.setLength(0);
                    while (v < p.length() && p.charAt(v) != '\"' && p.charAt(v) != '\'') {
                        sb.append(p.charAt(v++));
                    }
                    if (this.debug) {
                        err.println("unparsed-text(): encoding in XML declaration = " + sb.toString());
                    }
                    return sb.toString();
                }
                if (this.debug) {
                    err.println("unparsed-text(): no encoding found in XML declaration");
                }
            }
        } else {
            if (read > 0 && start[0] == 0 && start[2] == 0 && start[4] == 0 && start[6] == 0) {
                if (this.debug) {
                    err.println("unparsed-text(): even-numbered bytes are zero, inferring UTF-16");
                }
                return "UTF-16";
            }
            if (read > 1 && start[1] == 0 && start[3] == 0 && start[5] == 0 && start[7] == 0) {
                if (this.debug) {
                    err.println("unparsed-text(): odd-numbered bytes are zero, inferring UTF-16LE");
                }
                return "UTF-16LE";
            }
        }
        if (this.debug) {
            err.println("unparsed-text(): assuming fallback encoding (UTF-8)");
        }
        return "UTF-8";
    }

    private int ch(byte b) {
        return b & 0xFF;
    }
}

