# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

if [[ ${PV} != *9999* ]]; then
	SRC_URI="https://github.com/KDAB/KDSoap/releases/download/${P}/${P}.tar.gz"
	KEYWORDS="amd64 ~arm arm64 ~loong ~ppc64 ~riscv x86"
else
	EGIT_REPO_URI="https://github.com/KDAB/KDSoap.git"
	EGIT_SUBMODULES=( kdwsdl2cpp/libkode -autogen )
	inherit git-r3
fi
inherit cmake

DESCRIPTION="Qt-based client-side and server-side SOAP component"
HOMEPAGE="https://www.kdab.com/development-resources/qt-tools/kd-soap/"

LICENSE="GPL-3 AGPL-3"
SLOT="0/2"

RDEPEND="dev-qt/qtbase:6[network,xml]"
DEPEND="${RDEPEND}
	dev-libs/boost
"

src_prepare() {
	cmake_src_prepare
	sed -e "/install.*INSTALL_DOC_DIR/d" -i CMakeLists.txt || die
}

src_configure() {
	local mycmakeargs=(
		-DKDSoap_DOCS=OFF
		-DKDSoap_EXAMPLES=OFF # no install targets
		-DKDSoap_QT6=ON
		-DKDSoap_STATIC=OFF
	)
	cmake_src_configure
}
