# Copyright 2023-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.6.2

EAPI=8

CRATES="
"

LLVM_COMPAT=( {17..20} )
RUST_NEEDS_LLVM=1

inherit cargo llvm-r1 xdg-utils

DESCRIPTION="Sequoia's reimplementation of the GnuPG interface"
HOMEPAGE="https://sequoia-pgp.org/ https://gitlab.com/sequoia-pgp/sequoia-chameleon-gnupg/"
SRC_URI="
	https://gitlab.com/sequoia-pgp/sequoia-chameleon-gnupg/-/archive/v${PV}/${P}-v${PV}.tar.bz2
	${CARGO_CRATE_URIS}
"
SRC_URI+=" https://dev.gentoo.org/~sam/distfiles/${CATEGORY}/${PN}/${P}-crates.tar.xz"
S="${WORKDIR}"/${PN}-v${PV}-6fbe6d0fba83d5324ddf66a45cd349a458044b58

LICENSE="GPL-3+"
# Dependent crate licenses
LICENSE+="
	0BSD Apache-2.0 BSD Boost-1.0 CC0-1.0 ISC LGPL-2+ MIT MPL-2.0
	Unicode-3.0
	|| ( GPL-2 GPL-3 LGPL-3 )
"
SLOT="0"
KEYWORDS="amd64 arm64"
# Still some issue to do with columns?
RESTRICT="test"

DEPEND="
	app-arch/bzip2
	dev-db/sqlite:3
	dev-libs/gmp:=
	dev-libs/nettle:=
	dev-libs/openssl:=
"
# gpg-agent needed for secret key operations
# https://gitlab.com/sequoia-pgp/sequoia-chameleon-gnupg#gpg-sq
RDEPEND="
	${DEPEND}
	|| (
		app-crypt/gnupg
		app-crypt/freepg
	)
"
# Clang needed for bindgen
BDEPEND="
	$(llvm_gen_dep '
		llvm-core/clang:${LLVM_SLOT}
	')
"

QA_FLAGS_IGNORED="usr/bin/gpg-sq usr/bin/gpgv-sq"

pkg_setup() {
	llvm-r1_pkg_setup
	rust_pkg_setup
}

src_compile() {
	# https://wiki.gentoo.org/wiki/Project:Rust/sys_crates#bzip2-sys
	mkdir "${T}/pkg-config" || die
	export PKG_CONFIG_PATH=${T}/pkg-config${PKG_CONFIG_PATH+:${PKG_CONFIG_PATH}}
	cat >> "${T}/pkg-config/bzip2.pc" <<-EOF || die
	Name: bzip2
	Version: 9999
	Description:
	Libs: -lbz2
	EOF

	cargo_src_compile
}

src_test() {
	local -x GNUPGHOME="${T}"/.gnupg
	local -x REAL_GPG_BIN="${BROOT}"/usr/bin/gpg
	local -x REAL_GPGV_BIN="${BROOT}"/usr/bin/gpgv

	mkdir "${GNUPGHOME}" || die
	chmod 700 "${GNUPGHOME}" || die

	xdg_environment_reset
	RUST_BACKTRACE=full cargo_src_test -vv
}
