# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_EXT=1
DISTUTILS_USE_PEP517=setuptools
# TODO: freethreading
PYTHON_COMPAT=( python3_{11..14} )

inherit distutils-r1

MY_P=${P/_p/.post}
DESCRIPTION="Geometric objects, predicates, and operations"
HOMEPAGE="
	https://pypi.org/project/shapely/
	https://github.com/shapely/shapely/
"
SRC_URI="
	https://github.com/shapely/shapely/archive/${PV/_p/.post}.tar.gz
		-> ${MY_P}.gh.tar.gz
"
S=${WORKDIR}/${MY_P}

LICENSE="BSD"
SLOT="0"
KEYWORDS="amd64 arm64 ~x86"

DEPEND="
	dev-python/numpy:=[${PYTHON_USEDEP}]
	>=sci-libs/geos-3.11.4
"
RDEPEND="
	${DEPEND}
"
BDEPEND="
	${DEPEND}
	>=dev-python/cython-0.29.32[${PYTHON_USEDEP}]
	dev-python/packaging[${PYTHON_USEDEP}]
"

EPYTEST_PLUGINS=()
distutils_enable_tests pytest

python_test() {
	rm -rf shapely || die
	epytest --pyargs shapely
}
