/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file donaudb/pg_update_charity.c
 * @brief Implementation of the update_charity function for Postgres
 * @author Bohdan Potuzhnyi
 */
#include <donau_config.h>
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_update_charity.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
DH_PG_update_charity (
  void *cls,
  uint64_t charity_id,
  const struct DONAU_CharityPublicKeyP *charity_pub,
  const char *charity_name,
  const char *charity_url,
  const struct TALER_Amount *max_per_year)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_uint64 (&charity_id),
    GNUNET_PQ_query_param_auto_from_type (charity_pub),
    GNUNET_PQ_query_param_string (charity_name),
    GNUNET_PQ_query_param_string (charity_url),
    TALER_PQ_query_param_amount (pg->conn,
                                 max_per_year),
    GNUNET_PQ_query_param_end
  };

  PREPARE (pg,
           "update_charity",
           "UPDATE charities"
           "   SET charity_pub = $2"
           "      ,charity_name = $3"
           "      ,charity_url = $4"
           "      ,max_per_year = $5"
           " WHERE charity_id = $1;");
  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "update_charity",
                                             params);
}


/* end of pg_update_charity.c */
