/*
 * This file is part of LibEuFin.
 * Copyright (C) 2024 Taler Systems S.A.

 * LibEuFin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation; either version 3, or
 * (at your option) any later version.

 * LibEuFin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General
 * Public License for more details.

 * You should have received a copy of the GNU Affero General Public
 * License along with LibEuFin; see the file COPYING.  If not, see
 * <http://www.gnu.org/licenses/>
 */

package tech.libeufin.nexus.cli

import com.github.ajalt.clikt.core.CliktCommand
import com.github.ajalt.clikt.core.subcommands
import com.github.ajalt.clikt.parameters.options.flag
import com.github.ajalt.clikt.parameters.options.option
import com.github.ajalt.clikt.parameters.options.versionOption
import com.github.ajalt.clikt.parameters.types.path
import tech.libeufin.common.*
import tech.libeufin.nexus.NEXUS_CONFIG_SOURCE
import org.slf4j.Logger
import org.slf4j.LoggerFactory

internal val logger: Logger = LoggerFactory.getLogger("libeufin-nexus")

fun CliktCommand.ebicsLogOption() = option(
    "--debug-ebics",
    help = "Log EBICS transactions steps and payload at log_dir",
    metavar = "log_dir"
).path()

fun CliktCommand.transientOption() = option(
    "--transient",
    help = "Execute once and return, ignoring the 'FREQUENCY' configuration value"
).flag(default = false)

abstract class EbicsCmd(name: String? = null): TalerCmd(name) {
    val ebicsLog by ebicsLogOption()
    val transient by transientOption()
}


class LibeufinNexus : CliktCommand() {
    init {
        versionOption(VERSION)
        subcommands(DbInit(), EbicsSetup(), EbicsSubmit(), EbicsFetch(), Serve(), InitiatePayment(), ManualCmd(), ListCmd(), CliConfigCmd(NEXUS_CONFIG_SOURCE), TestingCmd())
    }
    override fun run() = Unit
}