/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Sets;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Parameterized {
    private Field field;
    private Method method;
    private Method getter;
    private WrappedParameter wrappedParameter;
    private ParametersDelegate parametersDelegate;

    public Parameterized(WrappedParameter wp, ParametersDelegate pd, Field field, Method method) {
        this.wrappedParameter = wp;
        this.method = method;
        this.field = field;
        if (this.field != null) {
            if (pd == null) {
                Parameterized.setFieldAccessible(this.field);
            } else {
                Parameterized.setFieldAccessibleWithoutFinalCheck(this.field);
            }
        }
        this.parametersDelegate = pd;
    }

    private static void describeClassTree(Class<?> inputClass, Set<Class<?>> setOfClasses) {
        if (inputClass == null) {
            return;
        }
        if (Object.class.equals(inputClass) || setOfClasses.contains(inputClass)) {
            return;
        }
        setOfClasses.add(inputClass);
        Parameterized.describeClassTree(inputClass.getSuperclass(), setOfClasses);
        for (Class<?> hasInterface : inputClass.getInterfaces()) {
            Parameterized.describeClassTree(hasInterface, setOfClasses);
        }
    }

    private static Set<Class<?>> describeClassTree(Class<?> inputClass) {
        if (inputClass == null) {
            return Collections.emptySet();
        }
        Set<Class<?>> classes = Sets.newLinkedHashSet();
        Parameterized.describeClassTree(inputClass, classes);
        return classes;
    }

    public static List<Parameterized> parseArg(Object arg) {
        List<Parameterized> result = Lists.newArrayList();
        Class<?> rootClass = arg.getClass();
        Set<Class<?>> types = Parameterized.describeClassTree(rootClass);
        HashSet bridgeOrSyntheticMethods = new HashSet();
        HashMap<String, Parameterized> methods = new HashMap<String, Parameterized>();
        for (Class<?> cls : types) {
            for (Field field : cls.getDeclaredFields()) {
                Parameter annotation = field.getAnnotation(Parameter.class);
                ParametersDelegate delegateAnnotation = field.getAnnotation(ParametersDelegate.class);
                DynamicParameter dynamicParameter = field.getAnnotation(DynamicParameter.class);
                if (annotation != null) {
                    result.add(new Parameterized(new WrappedParameter(annotation), null, field, null));
                    continue;
                }
                if (dynamicParameter != null) {
                    result.add(new Parameterized(new WrappedParameter(dynamicParameter), null, field, null));
                    continue;
                }
                if (delegateAnnotation == null) continue;
                result.add(new Parameterized(null, delegateAnnotation, field, null));
            }
            for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
                Parameterized parameterized2;
                if (((Method)accessibleObject).isBridge() || ((Method)accessibleObject).isSynthetic() || (parameterized2 = Parameterized.createParameterizedFromMethod((Method)accessibleObject)) == null) continue;
                methods.put(((Method)accessibleObject).getName(), parameterized2);
            }
            bridgeOrSyntheticMethods.addAll(Arrays.stream(cls.getDeclaredMethods()).filter(method -> method.isBridge() || method.isSynthetic()).collect(Collectors.toList()));
        }
        bridgeOrSyntheticMethods.stream().map(Parameterized::createParameterizedFromMethod).filter(Objects::nonNull).forEach(parameterized -> methods.putIfAbsent(parameterized.method.getName(), (Parameterized)parameterized));
        result.addAll(methods.values());
        return result;
    }

    private static Parameterized createParameterizedFromMethod(Method m) {
        m.setAccessible(true);
        Parameter annotation = m.getAnnotation(Parameter.class);
        ParametersDelegate delegateAnnotation = m.getAnnotation(ParametersDelegate.class);
        DynamicParameter dynamicParameter = m.getAnnotation(DynamicParameter.class);
        if (annotation != null) {
            return new Parameterized(new WrappedParameter(annotation), null, null, m);
        }
        if (dynamicParameter != null) {
            return new Parameterized(new WrappedParameter(dynamicParameter), null, null, m);
        }
        if (delegateAnnotation != null) {
            return new Parameterized(null, delegateAnnotation, null, m);
        }
        return null;
    }

    public WrappedParameter getWrappedParameter() {
        return this.wrappedParameter;
    }

    public Class<?> getType() {
        if (this.method != null) {
            return this.method.getParameterTypes()[0];
        }
        return this.field.getType();
    }

    public String getName() {
        if (this.method != null) {
            return this.method.getName();
        }
        return this.field.getName();
    }

    public Object get(Object object) {
        try {
            if (this.method != null) {
                if (this.getter == null) {
                    this.setGetter(object);
                }
                return this.getter.invoke(object, new Object[0]);
            }
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new ParameterException(e);
        }
        catch (NoSuchMethodException e) {
            String name = this.method.getName();
            String fieldName = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            Object result = null;
            try {
                Field field = this.method.getDeclaringClass().getDeclaredField(fieldName);
                if (field != null) {
                    Parameterized.setFieldAccessible(field);
                    result = field.get(object);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            return result;
        }
    }

    private void setGetter(Object object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (Boolean.class.getSimpleName().toLowerCase().equals(this.getType().getName())) {
            try {
                this.getter = object.getClass().getMethod("is" + this.method.getName().substring(3), new Class[0]);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.getter = object.getClass().getMethod("g" + this.method.getName().substring(1), new Class[0]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameterized other = (Parameterized)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public boolean isDynamicParameter(Field field) {
        if (this.method != null) {
            return this.method.getAnnotation(DynamicParameter.class) != null;
        }
        return this.field.getAnnotation(DynamicParameter.class) != null;
    }

    private static void setFieldAccessible(Field f) {
        if (Modifier.isFinal(f.getModifiers())) {
            throw new ParameterException("Cannot use final field " + f.getDeclaringClass().getName() + "#" + f.getName() + " as a parameter; compile-time constant inlining may hide new values written to it.");
        }
        f.setAccessible(true);
    }

    private static void setFieldAccessibleWithoutFinalCheck(Field f) {
        f.setAccessible(true);
    }

    private static String errorMessage(Method m, Exception ex) {
        return "Could not invoke " + m + "\n    Reason: " + ex.getMessage();
    }

    public void set(Object object, Object value) {
        try {
            if (this.method != null) {
                this.method.invoke(object, value);
            } else {
                this.field.set(object, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new ParameterException(Parameterized.errorMessage(this.method, ex));
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof ParameterException) {
                throw (ParameterException)ex.getTargetException();
            }
            throw new ParameterException(Parameterized.errorMessage(this.method, ex), ex.getTargetException());
        }
    }

    public ParametersDelegate getDelegateAnnotation() {
        return this.parametersDelegate;
    }

    public Type getGenericType() {
        if (this.method != null) {
            return this.method.getGenericParameterTypes()[0];
        }
        return this.field.getGenericType();
    }

    public Parameter getParameter() {
        return this.wrappedParameter.getParameter();
    }

    public Type findFieldGenericType() {
        if (this.method != null) {
            return null;
        }
        if (this.field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)this.field.getGenericType();
            Type cls = p.getActualTypeArguments()[0];
            if (cls instanceof Class) {
                return cls;
            }
            if (cls instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)cls;
                if (wildcardType.getLowerBounds().length > 0) {
                    return wildcardType.getLowerBounds()[0];
                }
                if (wildcardType.getUpperBounds().length > 0) {
                    return wildcardType.getUpperBounds()[0];
                }
            }
        }
        return null;
    }

    public boolean isDynamicParameter() {
        return this.wrappedParameter.getDynamicParameter() != null;
    }
}

