/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.ArrayList;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.Path;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenIntMap;

public class FnMin
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.minmax(true, qc);
    }

    final Item minmax(boolean min, QueryContext qc) throws QueryException {
        Item it;
        boolean numeric;
        Expr values = this.arg(0);
        Collation collation = this.toCollation(this.arg(1), qc);
        if (values instanceof Range) {
            Value value = values.value(qc);
            return value.isEmpty() ? Empty.VALUE : value.itemAt(min ? 0L : value.size() - 1L);
        }
        Iter iter = values.atomIter(qc, this.info);
        Item item = iter.next();
        if (item == null) {
            return Empty.VALUE;
        }
        Type type = item.type;
        if (!type.isSortable()) {
            throw QueryError.COMPARE_X_X.get(this.info, type, item);
        }
        boolean string = item instanceof AStr;
        boolean bl = numeric = !string && type != AtomType.BOOLEAN && !(item instanceof ADate) && !(item instanceof Dur) && !(item instanceof Bin);
        if (numeric) {
            if (type.isUntyped()) {
                item = AtomType.DOUBLE.cast(item, qc, this.info);
            }
            if (item == Dbl.NAN || item == Flt.NAN) {
                return item;
            }
        }
        while ((it = qc.next(iter)) != null) {
            block15: {
                Type type2;
                block14: {
                    block13: {
                        type2 = it.type;
                        if (numeric) {
                            if (type2.isUntyped()) {
                                it = AtomType.DOUBLE.cast(it, qc, this.info);
                            }
                            if (it == Dbl.NAN || it == Flt.NAN) {
                                return it;
                            }
                        }
                        if (!numeric) break block13;
                        if (!(it instanceof ANum)) break block14;
                        break block15;
                    }
                    if (!string ? type == type2 : it instanceof AStr) break block15;
                }
                throw QueryError.ARGTYPE_X_X_X.get(this.info, type, type2, it);
            }
            if (!(min ^ item.compare(it, collation, true, this.info) < 0)) continue;
            item = it;
        }
        return item;
    }

    @Override
    protected void simplifyArgs(CompileContext cc) throws QueryException {
        super.simplifyArgs(cc);
        if (this.arg((int)0).seqType().type.isNumberOrUntyped()) {
            this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.NUMBER, cc));
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        return this.opt(true, cc);
    }

    final Expr opt(boolean min, CompileContext cc) throws QueryException {
        Path path;
        ArrayList<Stats> list;
        this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.DATA, cc).simplifyFor(CompileContext.Simplify.DISTINCT, cc));
        Expr expr = this.optFirst();
        if (expr != this) {
            return expr;
        }
        boolean noColl = !this.defined(1);
        Expr values = this.arg(0);
        SeqType st = values.seqType();
        Type type = st.type;
        if (type.isSortable()) {
            if (type.isUntyped()) {
                type = AtomType.DOUBLE;
            } else if (st.one() && noColl) {
                return values;
            }
            this.exprType.assign(type);
            if (values instanceof Value) {
                Value value = (Value)values;
                if (noColl) {
                    SingletonSeq ss;
                    Item item = null;
                    long size = value.size();
                    if (value instanceof RangeSeq) {
                        RangeSeq rs;
                        item = rs.itemAt(min ^ (rs = (RangeSeq)value).ascending() ? size - 1L : 0L);
                    } else if (value instanceof SingletonSeq && (ss = (SingletonSeq)value).singleItem()) {
                        item = value.itemAt(0L);
                    } else if (value.size() == 1L) {
                        item = (Item)value;
                    }
                    if (item != null && ((type = item.seqType().type).isNumber() || type.instanceOf(AtomType.STRING))) {
                        return item;
                    }
                }
            }
        }
        if (noColl && values instanceof Path && (list = (path = (Path)values).pathStats()) != null) {
            double v = min ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            for (Stats stats : list) {
                if (!StatsType.isNumeric(stats.type)) {
                    return this;
                }
                TokenIntMap map = stats.values;
                if (map == null) {
                    v = min ? Math.min(v, stats.min) : Math.max(v, stats.max);
                    continue;
                }
                for (byte[] value : map) {
                    if (value.length == 0) {
                        return this;
                    }
                    double d = Token.toDouble(value);
                    v = min ? Math.min(v, d) : Math.max(v, d);
                }
            }
            return Dbl.get(v);
        }
        return this;
    }
}

