/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class YMDur
extends Dur {
    public YMDur(Dur value) {
        super(AtomType.YEAR_MONTH_DURATION);
        this.months = value.months;
        this.seconds = BigDecimal.ZERO;
    }

    public YMDur(YMDur value, YMDur dur, boolean plus, InputInfo info) throws QueryException {
        this(value);
        double d = (double)this.months + (double)(plus ? dur.months : -dur.months);
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw QueryError.MONTHRANGE_X.get(info, d);
        }
        this.months += plus ? dur.months : -dur.months;
    }

    public YMDur(Dur value, double factor, boolean mult, InputInfo info) throws QueryException {
        this(value);
        double d;
        if (Double.isNaN(factor)) {
            throw QueryError.DATECALC_X_X.get(info, this.description(), factor);
        }
        if (mult ? Double.isInfinite(factor) : factor == 0.0) {
            throw QueryError.DATEZERO_X_X.get(info, this.type, factor);
        }
        double d2 = d = mult ? (double)this.months * factor : (double)this.months / factor;
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw QueryError.MONTHRANGE_X.get(info, d);
        }
        this.months = StrictMath.round(d);
    }

    public YMDur(byte[] value, InputInfo info) throws QueryException {
        super(AtomType.YEAR_MONTH_DURATION);
        String val = Token.string(value).trim();
        Matcher mt = YMD.matcher(val);
        if (!mt.matches() || Strings.endsWith(val, 'P')) {
            throw this.dateError(value, "P2000Y12M", info);
        }
        this.yearMonth(value, mt, info);
        this.seconds = BigDecimal.ZERO;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeToken(this.string(null));
    }

    public long ymd() {
        return this.months;
    }

    @Override
    public byte[] string(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        if (this.months < 0L) {
            tb.add(45);
        }
        this.date(tb);
        if (this.months == 0L) {
            tb.add("0M");
        }
        return tb.finish();
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        return item.type == this.type ? Long.signum(this.months - ((Dur)item).months) : super.compare(item, coll, transitive, ii);
    }
}

