/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitemtype;

import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequenceType;
import net.xqj.core.XQDynamicExpression;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitemtype.XQItemTypeImpl;
import net.xqj.core.xqitemtype.XQSequenceTypeImpl;
import net.xqj.core.xqparser.v10.XQueryStatement10;

public final class XQItemTypeFactory {
    private static final XQItemTypeImpl[] ATOMIC_TYPES = new XQItemTypeImpl[52];
    private static XQItemTypeImpl COMMENT_TYPE = null;
    private static XQItemTypeImpl DOCUMENT_TYPE = null;
    private static XQItemTypeImpl ITEM_TYPE = null;
    private static XQItemTypeImpl NODE_TYPE = null;
    private static XQItemTypeImpl TEXT_TYPE = null;
    private static XQItemTypeImpl DOCUMENT_ELEMENT_TYPE = null;

    private XQItemTypeFactory() {
    }

    public static final XQItemType createAtomicType(int basetype) throws XQException {
        if (ATOMIC_TYPES[basetype] != null) {
            return ATOMIC_TYPES[basetype];
        }
        XQItemTypeFactory.ATOMIC_TYPES[basetype] = XQItemTypeImpl.newInstance(basetype);
        ATOMIC_TYPES[basetype].setTypeName(XQToolkit.getQName(XQDynamicExpression.XQJ_BASETYPE_MAP[basetype], "http://www.w3.org/2001/XMLSchema"));
        return ATOMIC_TYPES[basetype];
    }

    public static final XQItemType createAtomicType(int basetype, QName typename, URI schemaURI) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(basetype);
        xqitem.setTypeName(typename);
        xqitem.setSchemaURI(schemaURI);
        return xqitem;
    }

    public static final XQItemType createAttributeType(QName nodename, int basetype) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(basetype, 2);
        xqitem.setNodeName(nodename);
        return xqitem;
    }

    public static final XQItemType createAttributeType(QName nodename, int basetype, QName typename, URI schemaURI) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(basetype, 2);
        xqitem.setNodeName(nodename);
        xqitem.setSchemaURI(schemaURI);
        xqitem.setTypeName(typename);
        return xqitem;
    }

    public static final XQItemType createCommentType() throws XQException {
        if (COMMENT_TYPE != null) {
            return COMMENT_TYPE;
        }
        COMMENT_TYPE = XQItemTypeImpl.newInstance(2, 3);
        return COMMENT_TYPE;
    }

    public static final XQItemType createDocumentElementType(XQItemType elementType) throws XQException {
        boolean isRunOfMill = false;
        if (elementType.getBaseType() == 2 && elementType.getNodeName() == null && elementType.getSchemaURI() == null && !elementType.isElementNillable()) {
            if (DOCUMENT_ELEMENT_TYPE != null) {
                return DOCUMENT_ELEMENT_TYPE;
            }
            isRunOfMill = true;
        }
        XQItemTypeImpl xqItemType = XQItemTypeImpl.newInstance(elementType.getBaseType(), 5);
        xqItemType.setTypeName(elementType.getTypeName());
        xqItemType.setNodeName(elementType.getNodeName());
        xqItemType.setSchemaURI(elementType.getSchemaURI());
        xqItemType.setElementNillable(elementType.isElementNillable());
        if (isRunOfMill) {
            DOCUMENT_ELEMENT_TYPE = xqItemType;
            return DOCUMENT_ELEMENT_TYPE;
        }
        return xqItemType;
    }

    public static final XQItemType createDocumentSchemaElementType(XQItemType elementType) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(elementType.getBaseType(), 6);
        xqitem.setTypeName(elementType.getTypeName());
        xqitem.setNodeName(elementType.getNodeName());
        xqitem.setSchemaURI(elementType.getSchemaURI());
        xqitem.setElementNillable(elementType.isElementNillable());
        return xqitem;
    }

    public static final XQItemType createDocumentType() throws XQException {
        if (DOCUMENT_TYPE != null) {
            return DOCUMENT_TYPE;
        }
        DOCUMENT_TYPE = XQItemTypeImpl.newInstance(2, 4);
        return DOCUMENT_TYPE;
    }

    public static final XQItemType createElementType(QName nodename, int basetype) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(basetype, 7);
        xqitem.setNodeName(nodename);
        return xqitem;
    }

    public static final XQItemType createElementType(QName nodename, int basetype, QName typename, URI schemaURI, boolean allowNill) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(basetype, 7);
        xqitem.setNodeName(nodename);
        xqitem.setTypeName(typename);
        xqitem.setSchemaURI(schemaURI);
        xqitem.setElementNillable(allowNill);
        return xqitem;
    }

    public static final XQItemTypeImpl createItemType() throws XQException {
        if (ITEM_TYPE != null) {
            return ITEM_TYPE;
        }
        ITEM_TYPE = XQItemTypeImpl.newInstance(2, 8);
        return ITEM_TYPE;
    }

    public static final XQItemType createNodeType() throws XQException {
        if (NODE_TYPE != null) {
            return NODE_TYPE;
        }
        NODE_TYPE = XQItemTypeImpl.newInstance(1, 9);
        return NODE_TYPE;
    }

    public static final XQItemType createProcessingInstructionType(String piTarget) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(2, 10);
        xqitem.setPIName(piTarget);
        return xqitem;
    }

    public static final XQItemType createProcessingInstructionType(char[] piTarget, int offset, int length) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(2, 10);
        xqitem.setPIName(new String(piTarget, offset, length));
        return xqitem;
    }

    public static final XQItemType createSchemaAttributeType(QName nodename, int basetype, URI schemaURI) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(basetype, 13);
        xqitem.setNodeName(nodename);
        xqitem.setSchemaURI(schemaURI);
        return xqitem;
    }

    public static final XQItemType createSchemaElementType(QName nodename, int basetype, URI schemaURI) throws XQException {
        XQItemTypeImpl xqitem = XQItemTypeImpl.newInstance(basetype, 12);
        xqitem.setNodeName(nodename);
        xqitem.setSchemaURI(schemaURI);
        return xqitem;
    }

    public static final XQSequenceType createSequenceType(XQItemType item, int occurrence) throws XQException {
        return XQSequenceTypeImpl.newInstance(item, occurrence);
    }

    public static final XQItemType createTextType() throws XQException {
        if (TEXT_TYPE != null) {
            return TEXT_TYPE;
        }
        TEXT_TYPE = XQItemTypeImpl.newInstance(2, 11);
        return TEXT_TYPE;
    }

    public static final XQSequenceType createSequenceType(Reader lexicalRepresentation) throws XQException {
        try {
            return XQueryStatement10.parseXQSequenceType(lexicalRepresentation);
        }
        catch (Exception e) {
            throw new XQExceptionImpl("Failed to createQueryProcessor XQuery Sequence Type. " + e.getMessage(), "XQJTF001", e);
        }
    }

    public static final XQSequenceType createSequenceType(String lexicalRepresentation) throws XQException {
        return XQItemTypeFactory.createSequenceType(new StringReader(lexicalRepresentation));
    }
}

