/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.basex.core.Caches;
import org.basex.core.Databases;
import org.basex.core.Datas;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.Stores;
import org.basex.core.jobs.JobPool;
import org.basex.core.jobs.Jobs;
import org.basex.core.locks.Locking;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.core.users.Users;
import org.basex.data.Data;
import org.basex.io.random.TableDiskAccess;
import org.basex.query.util.pkg.EXPathRepo;
import org.basex.query.value.seq.DBNodes;
import org.basex.server.ClientBlocker;
import org.basex.server.ClientInfo;
import org.basex.server.Sessions;
import org.basex.util.log.Log;
import org.basex.util.options.Option;
import org.basex.util.options.Options;

public final class Context {
    public final ClientBlocker blocker;
    public final JobPool jobs;
    public final MainOptions options;
    public final StaticOptions soptions;
    public final Sessions sessions;
    public final Datas datas;
    public final Users users;
    public final EXPathRepo repo;
    public final Databases databases;
    public final Log log;
    public final Locking locking;
    public final Stores stores;
    public final Caches caches;
    private final HashSet<Object> external;
    private final ClientInfo client;
    private DBNodes current;
    private User user;
    private Data data;
    private boolean closed;
    public DBNodes marked;
    public DBNodes copied;
    public int focused = -1;

    public Context() {
        this(true);
    }

    public Context(boolean file) {
        this(new StaticOptions(file));
    }

    public Context(Context ctx) {
        this(ctx, null);
    }

    public Context(Context ctx, ClientInfo client) {
        this.client = client;
        this.soptions = ctx.soptions;
        this.options = new MainOptions(ctx.options);
        this.datas = ctx.datas;
        this.sessions = ctx.sessions;
        this.databases = ctx.databases;
        this.blocker = ctx.blocker;
        this.locking = ctx.locking;
        this.users = ctx.users;
        this.user = ctx.user;
        this.repo = ctx.repo;
        this.log = ctx.log;
        this.jobs = ctx.jobs;
        this.stores = ctx.stores;
        this.caches = ctx.caches;
        this.external = new HashSet<Object>(ctx.external);
    }

    public Context(StaticOptions soptions) {
        this.soptions = soptions;
        this.options = new MainOptions();
        this.datas = new Datas();
        this.sessions = new Sessions();
        this.blocker = new ClientBlocker();
        this.databases = new Databases(soptions);
        this.locking = new Locking(soptions);
        this.users = new Users(soptions);
        this.repo = new EXPathRepo(soptions);
        this.log = new Log(soptions);
        this.user = this.users.get("admin");
        this.jobs = new JobPool(soptions);
        this.external = new HashSet();
        this.stores = new Stores(this);
        this.caches = new Caches(this);
        this.client = null;
    }

    public User user() {
        return this.user;
    }

    public void user(User us) {
        this.user = us;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stores.close();
        this.jobs.close();
        this.sessions.close();
        this.datas.close();
        this.log.close();
        this.closeDB();
    }

    public void initServer() throws IOException {
        new Jobs(this).init();
        this.users.init(this);
    }

    public boolean root() {
        return this.data != null && this.current == null;
    }

    public Data data() {
        return this.data;
    }

    public DBNodes current() {
        if (this.data == null) {
            return null;
        }
        if (this.current != null) {
            return this.current;
        }
        return new DBNodes(this.data, true, this.data.resources.docs().toArray());
    }

    public void current(DBNodes curr) {
        this.current = curr.discardDocs();
    }

    public void openDB(Data dt) {
        this.data = dt;
        this.copied = null;
        this.set(null, new DBNodes(dt, new int[0]));
    }

    public void closeDB() {
        this.data = null;
        this.copied = null;
        this.set(null, null);
    }

    public void set(DBNodes curr, DBNodes mark) {
        this.current = curr;
        this.marked = mark;
        this.focused = -1;
    }

    public void invalidate() {
        this.current = null;
    }

    public boolean pinned(String db) {
        return this.datas.pinned(db) || TableDiskAccess.locked(db, this);
    }

    public String clientAddress() {
        return this.client != null ? this.client.clientAddress() : null;
    }

    public String clientName() {
        return this.client != null ? this.client.clientName() : (this.user != null ? this.user.name() : null);
    }

    public void setExternal(Object object) {
        this.external.add(object);
    }

    public Object getExternal(Class<?> clz) {
        for (Object object : this.external) {
            Class<?> c = object.getClass();
            if (c == clz) {
                return object;
            }
            for (Class<?> inter : c.getInterfaces()) {
                if (inter != clz) continue;
                return object;
            }
        }
        return null;
    }

    public HashMap<String, Object> options() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.user().has(Perm.ADMIN)) {
            for (Option<?> o : this.soptions) {
                map.put(o.name().toLowerCase(Locale.ENGLISH), this.soptions.get(o));
            }
        }
        for (Option<?> o : this.options) {
            map.put(o.name().toLowerCase(Locale.ENGLISH), this.options.get(o));
        }
        return map;
    }

    public Object option(String name) {
        Options opts = this.options;
        String uc = name.toUpperCase(Locale.ENGLISH);
        Option<?> opt = opts.option(uc);
        if (opt == null && this.user().has(Perm.ADMIN)) {
            opts = this.soptions;
            opt = opts.option(uc);
        }
        return opt != null ? opts.get(opt) : null;
    }
}

