/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.util.list.TokenList;

public class ArchiveExtractBinary
extends ArchiveFn {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        for (byte[] content : this.extract(qc)) {
            vb.add(B64.get(content));
        }
        return vb.value(this);
    }

    final TokenList extract(QueryContext qc) throws QueryException {
        TokenList tl;
        block22: {
            HashSet<String> entries = this.toEntries(this.arg(1), qc);
            tl = new TokenList();
            try {
                Object archive = this.toInput(this.arg(0), qc, entries != null);
                if (archive instanceof Bin) {
                    Bin bin = (Bin)archive;
                    try (BufferInput bi = bin.input(this.info);
                         ArchiveIn in = ArchiveIn.get(bi, this.info);){
                        while (in.more() && (entries == null || !entries.isEmpty())) {
                            ZipEntry ze = in.entry();
                            if (ze.isDirectory() || entries != null && !entries.remove(ze.getName())) continue;
                            ArrayOutput out = new ArrayOutput();
                            in.write(out);
                            tl.add(out.finish());
                        }
                        break block22;
                    }
                }
                try (ZipFile zip = new ZipFile(archive.toString());){
                    for (String entry : entries) {
                        ZipEntry ze = zip.getEntry(entry);
                        if (ze == null || ze.isDirectory()) continue;
                        ArrayOutput out = new ArrayOutput();
                        IO.write(zip.getInputStream(ze), out);
                        tl.add(out.finish());
                    }
                }
            }
            catch (IOException ex) {
                throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
            }
        }
        return tl;
    }
}

