/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.iter.Iter;
import org.basex.query.util.DeepEqualOptions;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;

public final class DeepEqual {
    private static final DeepEqualOptions DEFAULTS = new DeepEqualOptions();
    public final InputInfo info;
    public final QueryContext qc;
    public final Collation coll;
    public final DeepEqualOptions options;
    public FItem itemsEqual;
    public boolean nested;

    public DeepEqual() {
        this(null);
    }

    public DeepEqual(InputInfo info) {
        this(info, null, null);
    }

    public DeepEqual(InputInfo info, Collation coll, QueryContext qc) {
        this(info, coll, qc, null);
    }

    public DeepEqual(InputInfo info, Collation coll, QueryContext qc, DeepEqualOptions options) {
        this.info = info;
        this.coll = Collation.get(coll, info);
        this.qc = qc;
        this.options = options != null ? options : DEFAULTS;
    }

    public boolean equal(Value value1, Value value2) throws QueryException {
        long size2;
        if (value1 == value2) {
            return true;
        }
        long size1 = value1.size();
        return size1 == (size2 = value2.size()) && (size1 == 1L ? this.equal((Item)value1, (Item)value2) : this.equal(value1.iter(), value2.iter()));
    }

    public boolean equal(Iter iter1, Iter iter2) throws QueryException {
        Item item1;
        if (this.options.get(DeepEqualOptions.ORDERED).booleanValue()) {
            Item item2;
            Item item12;
            long size1 = iter1.size();
            long size2 = iter2.size();
            if (size1 != -1L && size2 != -1L && size1 != size2) {
                return false;
            }
            do {
                if (this.qc != null) {
                    this.qc.checkStop();
                }
                item12 = iter1.next();
                item2 = iter2.next();
                if (item12 != null && item2 != null) continue;
                return item12 == null && item2 == null;
            } while (this.equal(item12, item2));
            return false;
        }
        ItemList items2 = new ItemList();
        int size1 = 0;
        int size2 = 0;
        block1: while ((item1 = iter1.next()) != null) {
            Item item2;
            if (this.qc != null) {
                this.qc.checkStop();
            }
            ++size1;
            int i = items2.size();
            while (--i >= 0) {
                if (!this.equal(item1, (Item)items2.get(i))) continue;
                items2.remove(i);
                continue block1;
            }
            while ((item2 = iter2.next()) != null) {
                ++size2;
                if (this.equal(item1, item2)) continue block1;
                items2.add(item2);
            }
            return false;
        }
        return iter2.next() == null && size1 == size2;
    }

    public boolean equal(Item item1, Item item2) throws QueryException {
        Bln eq = this.itemsEqual(item1, item2);
        if (eq != null) {
            return eq.bool(this.info);
        }
        this.nested = false;
        return item1 == item2 || item1.deepEqual(item2, this);
    }

    public Bln itemsEqual(Item item1, Item item2) throws QueryException {
        Value value;
        Value test;
        if (this.itemsEqual != null && (test = Types.BOOLEAN_ZO.coerce(value = this.itemsEqual.invoke(this.qc, this.info, item1, item2), null, this.qc, null, this.info)) != Empty.VALUE) {
            return (Bln)test;
        }
        return null;
    }
}

