/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public final class Atts
extends ElementList {
    private byte[][] list;

    public Atts() {
        this(1L);
    }

    public Atts(long capacity) {
        this.list = new byte[Array.initialCapacity(capacity << 1)][];
    }

    public Atts(Atts atts) {
        this.list = (byte[][])atts.list.clone();
        this.size = atts.size;
    }

    @Override
    public int size() {
        return this.size >>> 1;
    }

    @Override
    public void size(int sz) {
        this.size = sz << 1;
    }

    public Atts add(byte[] name, byte[] value) {
        int s = this.size;
        byte[][] lst = this.list;
        if (s == lst.length) {
            this.list = lst = Array.copyOf(lst, Array.newCapacity(s >>> 1) << 1);
        }
        lst[s] = name;
        lst[s + 1] = value;
        this.size = s + 2;
        return this;
    }

    public Atts add(byte[] name, byte[] value, boolean stripNS) {
        byte[] local;
        if (!stripNS) {
            return this.add(name, value);
        }
        byte[] an = local = Token.local(name);
        int c = 0;
        while (this.contains(an)) {
            an = Token.concat(local, Character.valueOf('_'), Token.token(++c));
        }
        return this.add(an, value);
    }

    public Atts remove(int index) {
        byte[][] lst = this.list;
        int s = this.size;
        Array.remove(lst, index, 2, s);
        lst[s - 2] = null;
        lst[s - 1] = null;
        this.size = s - 2;
        return this;
    }

    public boolean contains(byte[] name) {
        return this.get(name) != -1;
    }

    public int get(byte[] name) {
        byte[][] lst = this.list;
        for (int p = 0; p < this.size; p += 2) {
            if (!Token.eq(lst[p], name)) continue;
            return p >>> 1;
        }
        return -1;
    }

    public byte[] name(int index) {
        return this.list[index << 1];
    }

    public byte[] value(int index) {
        return this.list[(index << 1) + 1];
    }

    public byte[] value(byte[] name) {
        int i = this.get(name);
        return i == -1 ? null : this.value(i);
    }

    public Atts optimize() {
        byte[][] lst = this.list;
        if (this.size != lst.length) {
            this.list = Array.copyOf(lst, this.size);
        }
        return this;
    }

    public boolean equals(Object obj) {
        Atts atts;
        return obj == this || obj instanceof Atts && this.equals(atts = (Atts)obj);
    }

    public boolean equals(Atts atts) {
        int s1 = this.size;
        int s2 = atts.size;
        if (s1 != s2) {
            return false;
        }
        byte[][] lst1 = this.list;
        byte[][] lst2 = atts.list;
        block0: for (int p1 = 0; p1 < s1; p1 += 2) {
            int p2 = 0;
            while (p2 != s1) {
                if (Token.eq(lst1[p1], lst2[p2])) {
                    if (Token.eq(lst1[p1 + 1], lst2[p2 + 1])) continue block0;
                    return false;
                }
                p2 += 2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder().add(Util.className(this)).add(91);
        for (int p = 0; p < this.size; p += 2) {
            if (p > 0) {
                tb.add(", ");
            }
            tb.add(this.list[p]).add("=\"").add(this.list[p + 1]).add("\"");
        }
        return tb.add("]").toString();
    }
}

