/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.datastructure.callgraph;

import java.util.Collections;
import java.util.Objects;
import proguard.analysis.datastructure.CodeLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.MethodSignature;
import proguard.classfile.instruction.Instruction;

public class SymbolicCall
extends Call {
    private final MethodSignature target;

    public SymbolicCall(CodeLocation caller, MethodSignature target, int throwsNullptr, Instruction instruction, boolean controlFlowDependent, boolean runtimeTypeDependent) {
        super(caller, null, Collections.emptyList(), null, throwsNullptr, instruction, controlFlowDependent, runtimeTypeDependent);
        this.target = target;
    }

    @Override
    public MethodSignature getTarget() {
        return this.target;
    }

    @Override
    public boolean hasIncompleteTarget() {
        return this.target == null || this.target.isIncomplete();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SymbolicCall that = (SymbolicCall)o;
        return Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.target);
    }
}

