/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;

public class ImplementedClassFilter
implements ClassVisitor {
    private final Clazz implementedClass;
    private final boolean includeImplementedClass;
    private final ClassVisitor acceptedClassVisitor;
    private final ClassVisitor rejectedClassVisitor;

    public ImplementedClassFilter(Clazz implementedClass, boolean includeImplementedClass, ClassVisitor acceptedClassVisitor, ClassVisitor rejectedClassVisistor) {
        this.implementedClass = implementedClass;
        this.includeImplementedClass = includeImplementedClass;
        this.acceptedClassVisitor = acceptedClassVisitor;
        this.rejectedClassVisitor = rejectedClassVisistor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        ClassVisitor visitor = this.delegateVisitor(clazz);
        if (visitor != null) {
            clazz.accept(visitor);
        }
    }

    private ClassVisitor delegateVisitor(Clazz clazz) {
        return clazz.extendsOrImplements(this.implementedClass) && (clazz != this.implementedClass || this.includeImplementedClass) ? this.acceptedClassVisitor : this.rejectedClassVisitor;
    }
}

