/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@BugPattern(summary="Very deeply nested code may lead to StackOverflowErrors during compilation", severity=BugPattern.SeverityLevel.WARNING)
public class DeeplyNested
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private final int maxDepth;

    @Inject
    DeeplyNested(ErrorProneFlags flags) {
        this.maxDepth = flags.getInteger("DeeplyNested:MaxDepth").orElse(1000);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        TreePath result = (TreePath)new BugChecker.SuppressibleTreePathScanner<TreePath, Integer>(state){

            public TreePath scan(Tree tree, Integer depth) {
                if (depth > DeeplyNested.this.maxDepth) {
                    return this.getCurrentPath();
                }
                return (TreePath)super.scan(tree, (Object)(depth + 1));
            }

            public TreePath reduce(TreePath r1, TreePath r2) {
                return r1 != null ? r1 : r2;
            }
        }.scan(state.getPath(), (Object)0);
        if (result != null) {
            return this.describeMatch(result.getLeaf(), DeeplyNested.buildFix(result, state));
        }
        return Description.NO_MATCH;
    }

    private static Fix buildFix(TreePath path, VisitorState state) {
        PeekingIterator it = Iterators.peekingIterator(path.iterator());
        while (it.hasNext() && !DeeplyNested.builderResult((Tree)it.peek())) {
            it.next();
        }
        if (!it.hasNext()) {
            return SuggestedFix.emptyFix();
        }
        ExpressionTree receiver = null;
        while (it.hasNext() && DeeplyNested.builderResult((Tree)it.peek())) {
            receiver = (ExpressionTree)it.peek();
            it.next();
        }
        it.next();
        if (!DeeplyNested.terminalBuilder((Tree)it.peek())) {
            return SuggestedFix.emptyFix();
        }
        it.next();
        Tree enclosing = (Tree)it.next();
        Type builderType = ASTHelpers.getResultType((ExpressionTree)receiver);
        ArrayList<ExpressionTree> chain = new ArrayList<ExpressionTree>();
        while (receiver != null && ASTHelpers.isSameType((Type)ASTHelpers.getResultType((ExpressionTree)receiver), (Type)builderType, (VisitorState)state)) {
            chain.add(receiver);
            if (receiver instanceof NewClassTree) break;
            receiver = ASTHelpers.getReceiver((ExpressionTree)receiver);
        }
        Collections.reverse(chain);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        StringBuilder replacement = new StringBuilder();
        replacement.append(String.format("%s builder = %s;", SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)builderType), state.getSourceForNode((Tree)chain.get(0))));
        for (int i = 1; i < chain.size(); ++i) {
            int start = state.getEndPosition((Tree)chain.get(i - 1));
            int end = state.getEndPosition((Tree)chain.get(i));
            List tokens = state.getOffsetTokens(start, end);
            int dot = tokens.stream().filter(t -> t.kind() == Tokens.TokenKind.DOT).findFirst().get().pos();
            replacement.append(String.format("%sbuilder%s;", state.getSourceCode().subSequence(start, dot), state.getSourceCode().subSequence(dot, end)));
        }
        if (enclosing instanceof ReturnTree) {
            replacement.append("return builder.build();");
            fix.replace(enclosing, replacement.toString());
            return fix.build();
        }
        if (enclosing instanceof VariableTree && ASTHelpers.isStatic((Symbol)ASTHelpers.getSymbol((Tree)enclosing))) {
            VariableTree variableTree = (VariableTree)enclosing;
            String factory = String.format("create%s", CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).convert((Object)variableTree.getName().toString()));
            fix.replace((Tree)variableTree.getInitializer(), String.format("%s()", factory));
            fix.postfixWith((Tree)variableTree, String.format("private static %s %s() { %s return builder.build(); }", SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)ASTHelpers.getType((Tree)variableTree)), factory, replacement));
            return fix.build();
        }
        return SuggestedFix.emptyFix();
    }

    private static boolean builderResult(Tree leaf) {
        if (!(leaf instanceof ExpressionTree)) {
            return false;
        }
        Type resultType = ASTHelpers.getResultType((ExpressionTree)((ExpressionTree)leaf));
        if (resultType == null) {
            return false;
        }
        return ((Name)resultType.asElement().getSimpleName()).contentEquals("Builder");
    }

    private static boolean terminalBuilder(Tree leaf) {
        if (!(leaf instanceof MethodInvocationTree)) {
            return false;
        }
        ExpressionTree select = ((MethodInvocationTree)leaf).getMethodSelect();
        return select instanceof MemberSelectTree && ((MemberSelectTree)select).getIdentifier().toString().startsWith("build");
    }
}

