/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

class NameMarker
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    NameMarker() {
    }

    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.keepClassName((Clazz)programClass);
        programClass.attributesAccept((AttributeVisitor)this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.keepClassName((Clazz)libraryClass);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.keepFieldName((Clazz)programClass, (Field)programField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.keepMethodName((Clazz)programClass, (Method)programMethod);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.keepFieldName((Clazz)libraryClass, (Field)libraryField);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.keepMethodName((Clazz)libraryClass, (Method)libraryMethod);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, (InnerClassesInfoVisitor)this);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        int innerClassIndex = innerClassesInfo.u2innerClassIndex;
        int outerClassIndex = innerClassesInfo.u2outerClassIndex;
        if (innerClassIndex != 0 && outerClassIndex != 0 && clazz.getClassName(innerClassIndex).equals(clazz.getName())) {
            clazz.constantPoolEntryAccept(outerClassIndex, (ConstantVisitor)this);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept((ClassVisitor)this);
    }

    public void keepClassName(Clazz clazz) {
        ClassObfuscator.setNewClassName(clazz, clazz.getName());
    }

    private void keepFieldName(Clazz clazz, Field field) {
        MemberObfuscator.setFixedNewMemberName((Member)field, field.getName(clazz));
    }

    private void keepMethodName(Clazz clazz, Method method) {
        String name = method.getName(clazz);
        if (!ClassUtil.isInitializer((String)name)) {
            MemberObfuscator.setFixedNewMemberName((Member)method, name);
        }
    }
}

