/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Comparator;

final class GenericParameterContext {
    private final ImmutableList<Annotation> annotationsOnParameter;
    private final Function<Class<? extends Annotation>, ImmutableList<? extends Annotation>> getAnnotationsFunction;
    private final Class<?> testClass;

    private GenericParameterContext(ImmutableList<Annotation> annotationsOnParameter, Function<Class<? extends Annotation>, ImmutableList<? extends Annotation>> getAnnotationsFunction, Class<?> testClass) {
        this.annotationsOnParameter = annotationsOnParameter;
        this.getAnnotationsFunction = getAnnotationsFunction;
        this.testClass = testClass;
    }

    static GenericParameterContext create(Field field, Class<?> testClass) {
        return new GenericParameterContext((ImmutableList<Annotation>)ImmutableList.copyOf((Object[])field.getAnnotations()), (Function<Class<? extends Annotation>, ImmutableList<? extends Annotation>>)((Function)annotationType -> {
            try {
                return ImmutableList.copyOf((Object[])field.getAnnotationsByType((Class)annotationType));
            }
            catch (NoSuchMethodError ignored) {
                return GenericParameterContext.getAnnotationsFallback((ImmutableList<Annotation>)ImmutableList.copyOf((Object[])field.getAnnotations()), annotationType);
            }
        }), testClass);
    }

    static GenericParameterContext create(Parameter parameter, Class<?> testClass) {
        return new GenericParameterContext((ImmutableList<Annotation>)ImmutableList.copyOf((Object[])parameter.getAnnotations()), (Function<Class<? extends Annotation>, ImmutableList<? extends Annotation>>)((Function)annotationType -> ImmutableList.copyOf((Object[])parameter.getAnnotationsByType((Class)annotationType))), testClass);
    }

    static GenericParameterContext create(Executable executable, Class<?> testClass) {
        return new GenericParameterContext((ImmutableList<Annotation>)ImmutableList.copyOf((Object[])executable.getAnnotations()), (Function<Class<? extends Annotation>, ImmutableList<? extends Annotation>>)((Function)annotationType -> ImmutableList.copyOf((Object[])executable.getAnnotationsByType((Class)annotationType))), testClass);
    }

    static GenericParameterContext createWithRepeatableAnnotationsFallback(Annotation[] annotationsOnParameter, Class<?> testClass) {
        return new GenericParameterContext((ImmutableList<Annotation>)ImmutableList.copyOf((Object[])annotationsOnParameter), (Function<Class<? extends Annotation>, ImmutableList<? extends Annotation>>)((Function)annotationType -> GenericParameterContext.getAnnotationsFallback((ImmutableList<Annotation>)ImmutableList.copyOf((Object[])annotationsOnParameter), annotationType)), testClass);
    }

    static GenericParameterContext createWithoutParameterAnnotations(Class<?> testClass) {
        return new GenericParameterContext((ImmutableList<Annotation>)ImmutableList.of(), (Function<Class<? extends Annotation>, ImmutableList<? extends Annotation>>)((Function)annotationType -> GenericParameterContext.getAnnotationsFallback((ImmutableList<Annotation>)ImmutableList.of(), annotationType)), testClass);
    }

    <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)Iterables.getOnlyElement((Iterable)FluentIterable.from(this.annotationsOnParameter).filter(annotation -> annotation.annotationType().equals(annotationType)).toList()));
    }

    <A extends Annotation> ImmutableList<A> getAnnotations(Class<A> annotationType) {
        return (ImmutableList)this.getAnnotationsFunction.apply(annotationType);
    }

    Class<?> testClass() {
        return this.testClass;
    }

    ImmutableList<Annotation> annotationsOnParameter() {
        return this.annotationsOnParameter;
    }

    public String toString() {
        return String.format("context(annotationsOnParameter=[%s],testClass=%s)", FluentIterable.from((Iterable)ImmutableList.sortedCopyOf((Comparator)Ordering.natural().onResultOf(Annotation::toString), this.annotationsOnParameter)).transform(annotation -> String.format("@%s", annotation.annotationType().getSimpleName())).join(Joiner.on((char)',')), this.testClass().getSimpleName());
    }

    private static ImmutableList<Annotation> getAnnotationsFallback(ImmutableList<Annotation> annotationsOnParameter, Class<? extends Annotation> annotationType) {
        ImmutableList candidates = FluentIterable.from(annotationsOnParameter).filter(annotation -> annotation.annotationType().equals(annotationType)).toList();
        if (candidates.isEmpty() && GenericParameterContext.getContainerType(annotationType).isPresent()) {
            ImmutableList<Annotation> containerAnnotations = GenericParameterContext.getAnnotationsFallback(annotationsOnParameter, (Class)GenericParameterContext.getContainerType(annotationType).get());
            if (containerAnnotations.size() == 1) {
                Annotation containerAnnotation = (Annotation)Iterables.getOnlyElement(containerAnnotations);
                try {
                    Method annotationValueMethod = containerAnnotation.annotationType().getDeclaredMethod("value", new Class[0]);
                    annotationValueMethod.setAccessible(true);
                    return ImmutableList.copyOf((Object[])((Annotation[])Proxy.getInvocationHandler(containerAnnotation).invoke(containerAnnotation, annotationValueMethod, null)));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return ImmutableList.of();
        }
        return candidates;
    }

    private static Optional<Class<? extends Annotation>> getContainerType(Class<? extends Annotation> annotationType) {
        try {
            Repeatable repeatable = annotationType.getAnnotation(Repeatable.class);
            if (repeatable == null) {
                return Optional.absent();
            }
            return Optional.of(repeatable.value());
        }
        catch (NoClassDefFoundError ignored) {
            return Optional.absent();
        }
    }
}

