;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
 ;; CHECK-TEXT:      (type $0 (func))
 ;; CHECK-BIN:      (type $0 (func))
 ;; CHECK-BIN-NODEBUG:      (type $0 (func))
 (type $0 (func))
 ;; CHECK-TEXT:      (memory $appMemory i64 23 256 shared)
 ;; CHECK-BIN:      (memory $appMemory i64 23 256 shared)
 (memory $appMemory i64 23 256 shared)
 ;; CHECK-TEXT:      (memory $dataMemory i64 23 256 shared)
 ;; CHECK-BIN:      (memory $dataMemory i64 23 256 shared)
 (memory $dataMemory i64 23 256 shared)
 ;; CHECK-TEXT:      (memory $instrumentMemory i64 23 256 shared)
 ;; CHECK-BIN:      (memory $instrumentMemory i64 23 256 shared)
 (memory $instrumentMemory i64 23 256 shared)

 ;; CHECK-TEXT:      (func $atomic-loadstore (type $0)
 ;; CHECK-TEXT-NEXT:  (local $0 i64)
 ;; CHECK-TEXT-NEXT:  (local $1 i64)
 ;; CHECK-TEXT-NEXT:  (local $2 i32)
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.load8_u $appMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.load8_u $appMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.load16_u $dataMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.load16_u $instrumentMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.load $dataMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.load $appMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load8_u $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load8_u $dataMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load16_u $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load16_u $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load32_u $instrumentMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load32_u $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load $instrumentMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i32.atomic.store $appMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $2)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i32.atomic.store $appMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $2)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i32.atomic.store8 $instrumentMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $2)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i32.atomic.store8 $dataMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $2)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i32.atomic.store16 $appMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $2)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i32.atomic.store16 $dataMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $2)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store $appMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store $appMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store8 $dataMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store8 $instrumentMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store16 $appMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store16 $appMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store32 $instrumentMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store32 $dataMemory offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-loadstore (type $0)
 ;; CHECK-BIN-NEXT:  (local $0 i64)
 ;; CHECK-BIN-NEXT:  (local $1 i64)
 ;; CHECK-BIN-NEXT:  (local $2 i32)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.load8_u $appMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.load8_u $appMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.load16_u $dataMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.load16_u $instrumentMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.load $dataMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.load $appMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load8_u $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load8_u $dataMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load16_u $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load16_u $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load32_u $instrumentMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load32_u $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load $instrumentMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i32.atomic.store $appMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $2)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i32.atomic.store $appMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $2)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i32.atomic.store8 $instrumentMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $2)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i32.atomic.store8 $dataMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $2)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i32.atomic.store16 $appMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $2)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i32.atomic.store16 $dataMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $2)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store $appMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store $appMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store8 $dataMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store8 $instrumentMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store16 $appMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store16 $appMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store32 $instrumentMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store32 $dataMemory offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $atomic-loadstore
  (local $0 i64)
  (local $1 i64)
  (local $2 i32)
  (drop
   (i32.atomic.load8_u $appMemory offset=4
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.load8_u $appMemory offset=4
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.load16_u $dataMemory offset=4
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.load16_u $instrumentMemory offset=4
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.load $dataMemory offset=4
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.load $appMemory offset=4
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load8_u $appMemory
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load8_u $dataMemory
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load16_u $appMemory
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load16_u $appMemory
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load32_u $instrumentMemory
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load32_u $appMemory
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load $appMemory
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load $instrumentMemory
    (local.get $0)
   )
  )
  (i32.atomic.store $appMemory offset=4
   (local.get $0)
   (local.get $2)
  )
  (i32.atomic.store $appMemory offset=4
   (local.get $0)
   (local.get $2)
  )
  (i32.atomic.store8 $instrumentMemory offset=4
   (local.get $0)
   (local.get $2)
  )
  (i32.atomic.store8 $dataMemory offset=4
   (local.get $0)
   (local.get $2)
  )
  (i32.atomic.store16 $appMemory offset=4
   (local.get $0)
   (local.get $2)
  )
  (i32.atomic.store16 $dataMemory offset=4
   (local.get $0)
   (local.get $2)
  )
  (i64.atomic.store $appMemory offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store $appMemory offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store8 $dataMemory offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store8 $instrumentMemory offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store16 $appMemory offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store16 $appMemory offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store32 $instrumentMemory offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store32 $dataMemory offset=4
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $atomic-rmw (type $0)
 ;; CHECK-TEXT-NEXT:  (local $0 i64)
 ;; CHECK-TEXT-NEXT:  (local $1 i64)
 ;; CHECK-TEXT-NEXT:  (local $2 i32)
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw.add $dataMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw.add $instrumentMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw8.add_u $appMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw8.add_u $appMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw16.and_u $dataMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw16.and_u $instrumentMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.rmw32.or_u $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.rmw32.or_u $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw8.xchg_u $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw8.xchg_u $dataMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-rmw (type $0)
 ;; CHECK-BIN-NEXT:  (local $0 i64)
 ;; CHECK-BIN-NEXT:  (local $1 i64)
 ;; CHECK-BIN-NEXT:  (local $2 i32)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw.add $dataMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw.add $instrumentMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw8.add_u $appMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw8.add_u $appMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw16.and_u $dataMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw16.and_u $instrumentMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.rmw32.or_u $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.rmw32.or_u $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw8.xchg_u $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw8.xchg_u $dataMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $atomic-rmw
  (local $0 i64)
  (local $1 i64)
  (local $2 i32)
  (drop
   (i32.atomic.rmw.add $dataMemory offset=4
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (i32.atomic.rmw.add $instrumentMemory offset=4
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (i32.atomic.rmw8.add_u $appMemory offset=4
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (i32.atomic.rmw8.add_u $appMemory offset=4
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (i32.atomic.rmw16.and_u $dataMemory
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (i32.atomic.rmw16.and_u $instrumentMemory
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (i64.atomic.rmw32.or_u $appMemory
    (local.get $0)
    (local.get $1)
   )
  )
  (drop
   (i64.atomic.rmw32.or_u $appMemory
    (local.get $0)
    (local.get $1)
   )
  )
  (drop
   (i32.atomic.rmw8.xchg_u $appMemory
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (i32.atomic.rmw8.xchg_u $dataMemory
    (local.get $0)
    (local.get $2)
   )
  )
 )

 ;; CHECK-TEXT:      (func $atomic-cmpxchg (type $0)
 ;; CHECK-TEXT-NEXT:  (local $0 i64)
 ;; CHECK-TEXT-NEXT:  (local $1 i64)
 ;; CHECK-TEXT-NEXT:  (local $2 i32)
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw.cmpxchg $appMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw.cmpxchg $instrumentMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw8.cmpxchg_u $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw8.cmpxchg_u $appMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.rmw.cmpxchg $appMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.rmw.cmpxchg $dataMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.rmw32.cmpxchg_u $instrumentMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.rmw32.cmpxchg_u $dataMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-cmpxchg (type $0)
 ;; CHECK-BIN-NEXT:  (local $0 i64)
 ;; CHECK-BIN-NEXT:  (local $1 i64)
 ;; CHECK-BIN-NEXT:  (local $2 i32)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw.cmpxchg $appMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw.cmpxchg $instrumentMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw8.cmpxchg_u $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw8.cmpxchg_u $appMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.rmw.cmpxchg $appMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.rmw.cmpxchg $dataMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.rmw32.cmpxchg_u $instrumentMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.rmw32.cmpxchg_u $dataMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $atomic-cmpxchg
  (local $0 i64)
  (local $1 i64)
  (local $2 i32)
  (drop
   (i32.atomic.rmw.cmpxchg $appMemory offset=4
    (local.get $0)
    (local.get $2)
    (local.get $2)
   )
  )
  (drop
   (i32.atomic.rmw.cmpxchg $instrumentMemory offset=4
    (local.get $0)
    (local.get $2)
    (local.get $2)
   )
  )
  (drop
   (i32.atomic.rmw8.cmpxchg_u $appMemory
    (local.get $0)
    (local.get $2)
    (local.get $2)
   )
  )
  (drop
   (i32.atomic.rmw8.cmpxchg_u $appMemory
    (local.get $0)
    (local.get $2)
    (local.get $2)
   )
  )
  (drop
   (i64.atomic.rmw.cmpxchg $appMemory offset=4
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
  (drop
   (i64.atomic.rmw.cmpxchg $dataMemory offset=4
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
  (drop
   (i64.atomic.rmw32.cmpxchg_u $instrumentMemory
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
  (drop
   (i64.atomic.rmw32.cmpxchg_u $dataMemory
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
 )

 ;; CHECK-TEXT:      (func $atomic-wait-notify (type $0)
 ;; CHECK-TEXT-NEXT:  (local $0 i64)
 ;; CHECK-TEXT-NEXT:  (local $1 i64)
 ;; CHECK-TEXT-NEXT:  (local $2 i32)
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait32 $dataMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait32 $instrumentMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait32 $appMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait32 $instrumentMemory offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.notify $dataMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.notify $dataMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.notify $appMemory offset=24
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.notify $dataMemory offset=24
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait64 $instrumentMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait64 $instrumentMemory
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait64 $appMemory offset=16
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait64 $appMemory offset=16
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-wait-notify (type $0)
 ;; CHECK-BIN-NEXT:  (local $0 i64)
 ;; CHECK-BIN-NEXT:  (local $1 i64)
 ;; CHECK-BIN-NEXT:  (local $2 i32)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait32 $dataMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait32 $instrumentMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait32 $appMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait32 $instrumentMemory offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.notify $dataMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.notify $dataMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.notify $appMemory offset=24
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.notify $dataMemory offset=24
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $2)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait64 $instrumentMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait64 $instrumentMemory
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait64 $appMemory offset=16
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait64 $appMemory offset=16
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $atomic-wait-notify
  (local $0 i64)
  (local $1 i64)
  (local $2 i32)
  (drop
   (memory.atomic.wait32 $dataMemory
    (local.get $0)
    (local.get $2)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.wait32 $instrumentMemory
    (local.get $0)
    (local.get $2)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.wait32 $appMemory offset=4
    (local.get $0)
    (local.get $2)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.wait32 $instrumentMemory offset=4
    (local.get $0)
    (local.get $2)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.notify $dataMemory
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (memory.atomic.notify $dataMemory
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (memory.atomic.notify $appMemory offset=24
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (memory.atomic.notify $dataMemory offset=24
    (local.get $0)
    (local.get $2)
   )
  )
  (drop
   (memory.atomic.wait64 $instrumentMemory
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.wait64 $instrumentMemory
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.wait64 $appMemory offset=16
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.wait64 $appMemory offset=16
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
 )

 ;; CHECK-TEXT:      (func $atomic-fence (type $0)
 ;; CHECK-TEXT-NEXT:  (atomic.fence)
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-fence (type $0)
 ;; CHECK-BIN-NEXT:  (atomic.fence)
 ;; CHECK-BIN-NEXT: )
 (func $atomic-fence
  (atomic.fence)
 )
)
;; CHECK-BIN-NODEBUG:      (memory $0 i64 23 256 shared)

;; CHECK-BIN-NODEBUG:      (memory $1 i64 23 256 shared)

;; CHECK-BIN-NODEBUG:      (memory $2 i64 23 256 shared)

;; CHECK-BIN-NODEBUG:      (func $0 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.load8_u $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.load8_u $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.load16_u $1 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.load16_u $2 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.load $1 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.load $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load8_u $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load8_u $1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load16_u $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load16_u $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load32_u $2
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load32_u $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load $2
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.atomic.store $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.atomic.store $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.atomic.store8 $2 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.atomic.store8 $1 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.atomic.store16 $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.atomic.store16 $1 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store8 $1 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store8 $2 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store16 $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store16 $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store32 $2 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store32 $1 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw.add $1 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw.add $2 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw8.add_u $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw8.add_u $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw16.and_u $1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw16.and_u $2
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.rmw32.or_u $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.rmw32.or_u $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw8.xchg_u $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw8.xchg_u $1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw.cmpxchg $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw.cmpxchg $2 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw8.cmpxchg_u $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw8.cmpxchg_u $0
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.rmw.cmpxchg $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.rmw.cmpxchg $1 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.rmw32.cmpxchg_u $2
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.rmw32.cmpxchg_u $1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait32 $1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait32 $2
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait32 $0 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait32 $2 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.notify $1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.notify $1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.notify $0 offset=24
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.notify $1 offset=24
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait64 $2
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait64 $2
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait64 $0 offset=16
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait64 $0 offset=16
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $4 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (atomic.fence)
;; CHECK-BIN-NODEBUG-NEXT: )
