//===----------------------------------------------------------------------===//
// Copyright © 2026 Apple Inc. and the container project authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

public enum Arch: String {
    case arm64, amd64

    public init?(rawValue: String) {
        switch rawValue.lowercased() {
        case "arm64", "aarch64":
            self = .arm64
        case "amd64", "x86_64", "x86-64":
            self = .amd64
        default:
            return nil
        }
    }

    public static func hostArchitecture() -> Arch {
        #if arch(arm64)
        return .arm64
        #elseif arch(x86_64)
        return .amd64
        #endif
    }
}
