/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.ignite.thin;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;

public class IgniteThinParser
extends Parser {
    private static final List<String> DDL_KEYWORDS = Arrays.asList("CREATE", "ALTER", "DROP");

    public IgniteThinParser(Configuration configuration, ParsingContext parsingContext) {
        super(configuration, parsingContext, 2);
    }

    protected char getAlternativeStringLiteralQuote() {
        return '$';
    }

    protected Token handleAlternativeStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        String dollarQuote = (char)reader.read() + reader.readUntilIncluding('$');
        reader.swallowUntilExcluding(dollarQuote);
        reader.swallow(dollarQuote.length());
        return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
    }

    protected Boolean detectCanExecuteInTransaction(String simplifiedStatement, List<Token> keywords) {
        return keywords.stream().noneMatch(token -> token.getType().equals((Object)TokenType.KEYWORD) && DDL_KEYWORDS.contains(token.getText()));
    }
}

