/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ano;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import oracle.net.ano.Ano;
import oracle.net.aso.k;
import oracle.net.aso.m;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

class CryptoNIONSDataChannel
extends NIONSDataChannel
implements SQLnetDef {
    private m f = null;
    private k g = null;
    private int C = 0;
    private int D = 0;
    private Ano ano = null;

    public CryptoNIONSDataChannel(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.ano = sessionAtts.ano;
        if (sessionAtts.ano.f != null) {
            this.f = sessionAtts.ano.f;
            this.D += this.f.z();
        }
        if (sessionAtts.ano.g != null) {
            this.g = sessionAtts.ano.g;
            this.D += this.g.size();
        }
        ++this.D;
    }

    @Override
    public void readDataFromSocketChannel() {
        super.readDataFromSocketChannel();
        this.ano = this.session.ano;
        this.D = 0;
        if (this.ano.f != null) {
            this.f = this.ano.f;
            this.D += this.f.z();
            if (this.ano.getRenewKey()) {
                this.f.a(null, null);
            }
        }
        if (this.ano.g != null) {
            this.g = this.ano.g;
            this.D += this.g.size();
            if (this.ano.getRenewKey()) {
                this.g.R();
            }
        }
        ++this.D;
        this.ano.setRenewKey(false);
        try {
            CryptoNIONSDataChannel cryptoNIONSDataChannel = this;
            int n2 = cryptoNIONSDataChannel.session.payloadDataBufferForRead.position();
            ByteOrder byteOrder = cryptoNIONSDataChannel.session.payloadDataBufferForRead.order();
            cryptoNIONSDataChannel.session.payloadDataBufferForRead.order(ByteOrder.BIG_ENDIAN);
            int n3 = cryptoNIONSDataChannel.session.payloadDataBufferForRead.limit();
            if (n3 > 0) {
                cryptoNIONSDataChannel.session.payloadDataBufferForRead.position(n3 - 1);
                cryptoNIONSDataChannel.session.payloadDataBufferForRead.get();
                cryptoNIONSDataChannel.session.payloadDataBufferForRead.position(n2);
                cryptoNIONSDataChannel.session.payloadDataBufferForRead.order(byteOrder);
                --n3;
            }
            byte[] byArray = new byte[n3];
            int n4 = cryptoNIONSDataChannel.session.payloadDataBufferForRead.limit();
            cryptoNIONSDataChannel.session.payloadDataBufferForRead.get(byArray);
            cryptoNIONSDataChannel.session.payloadDataBufferForRead.position(n2);
            cryptoNIONSDataChannel.session.payloadDataBufferForRead.limit(n4);
            if (cryptoNIONSDataChannel.f != null && n3 > 0) {
                byArray = cryptoNIONSDataChannel.f.f(byArray);
            }
            if (byArray == null) {
                throw new IOException("Bad buffer - Fail to decrypt buffer");
            }
            n3 = byArray.length;
            if (cryptoNIONSDataChannel.g != null && n3 > 0) {
                byte[] byArray2 = new byte[cryptoNIONSDataChannel.g.size()];
                System.arraycopy(byArray, n3 -= cryptoNIONSDataChannel.g.size(), byArray2, 0, cryptoNIONSDataChannel.g.size());
                byte[] byArray3 = new byte[n3];
                System.arraycopy(byArray, 0, byArray3, 0, n3);
                if (cryptoNIONSDataChannel.g.c(byArray3, byArray2)) {
                    throw new IOException("Checksum fail");
                }
                cryptoNIONSDataChannel.session.payloadDataBufferForRead = ByteBuffer.wrap(byArray3, 0, n3);
                cryptoNIONSDataChannel.session.payloadDataBufferForRead.limit(n3);
                cryptoNIONSDataChannel.session.payloadDataBufferForRead.order(byteOrder);
            } else {
                cryptoNIONSDataChannel.session.payloadDataBufferForRead = ByteBuffer.wrap(byArray, 0, n3);
                cryptoNIONSDataChannel.session.payloadDataBufferForRead.limit(n3);
                cryptoNIONSDataChannel.session.payloadDataBufferForRead.order(byteOrder);
            }
            cryptoNIONSDataChannel.session.payloadDataBufferForRead.position(n2);
            return;
        }
        catch (Exception exception) {
            this.ano.checkForAnoNegotiationFailure();
            throw exception;
        }
    }

    @Override
    public void writeDataToSocketChannel() {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        Object object;
        if (this.C < 2) {
            try {
                object = this;
                byArray3 = ((CryptoNIONSDataChannel)object).ano.b();
                byte[] byArray4 = ((CryptoNIONSDataChannel)object).ano.getO3logSessionKey();
                if (byArray4 != null) {
                    byArray2 = new byte[Math.max(byArray4.length, byArray3.length)];
                    byArray = byArray4.length > byArray3.length ? byArray4 : byArray3;
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    if (byArray4.length < 8 || byArray3.length < 8) {
                        throw new IOException("Key is too small");
                    }
                    for (int i2 = 0; i2 < 8; ++i2) {
                        byArray2[i2] = (byte)(byArray4[i2] ^ byArray3[i2]);
                    }
                    byte[] byArray5 = ((CryptoNIONSDataChannel)object).ano.a();
                    if (((CryptoNIONSDataChannel)object).f != null) {
                        ((CryptoNIONSDataChannel)object).f.a(byArray2, byArray5);
                    }
                    if (((CryptoNIONSDataChannel)object).g != null) {
                        ((CryptoNIONSDataChannel)object).g.d(byArray2, byArray5);
                    }
                    ((CryptoNIONSDataChannel)object).C = 3;
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                throw iOException;
            }
        }
        try {
            object = this;
            int n2 = ((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.position();
            byArray2 = new byte[((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.position()];
            ((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.limit(((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.position());
            ((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.position(0);
            ((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.get(byArray2);
            ((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.position(0);
            ((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.limit(((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.capacity());
            byArray = null;
            int n3 = n2;
            if (((CryptoNIONSDataChannel)object).g != null && (byArray = ((CryptoNIONSDataChannel)object).g.e(byArray2, byArray2.length)) != null) {
                n3 += byArray.length;
            }
            byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
            }
            if (((CryptoNIONSDataChannel)object).f != null) {
                if ((byArray3 = ((CryptoNIONSDataChannel)object).f.g(byArray3)) == null) {
                    throw new IOException("Fail to encrypt buffer");
                }
                n3 = byArray3.length;
                ((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.put(byArray3);
            } else if (((CryptoNIONSDataChannel)object).g != null) {
                ((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.put(byArray3);
            }
            if (n3 > 0) {
                ((CryptoNIONSDataChannel)object).session.payloadDataBufferForWrite.put((byte)(((CryptoNIONSDataChannel)object).C >= 2 ? 1 : 0));
            }
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
        super.writeDataToSocketChannel();
    }

    @Override
    public int getDataExpansionByteSize() {
        return this.D;
    }

    @Override
    protected void processMarker() {
        this.session.ano.setRenewKey(true);
    }
}

