/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop.verifiers;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop.verifiers.AccessTokenValidationException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPCommonVerifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop.verifiers.InvalidDPoPProofException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.JWTID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.singleuse.SingleUseChecker;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.Nonce;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DPoPTokenRequestVerifier
extends DPoPCommonVerifier {
    private final URI endpointURI;

    public DPoPTokenRequestVerifier(Set<JWSAlgorithm> acceptedJWSAlgs, URI endpointURI, long maxClockSkewSeconds, SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker) {
        super(acceptedJWSAlgs, maxClockSkewSeconds, singleUseChecker);
        this.endpointURI = Objects.requireNonNull(endpointURI);
    }

    @Deprecated
    public JWKThumbprintConfirmation verify(DPoPIssuer issuer, SignedJWT proof) throws InvalidDPoPProofException, JOSEException {
        return this.verify(issuer, proof, null);
    }

    public JWKThumbprintConfirmation verify(DPoPIssuer issuer, SignedJWT proof, Nonce nonce) throws InvalidDPoPProofException, JOSEException {
        try {
            super.verify("POST", this.endpointURI, issuer, proof, null, null, nonce);
        }
        catch (AccessTokenValidationException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        return new JWKThumbprintConfirmation(proof.getHeader().getJWK().computeThumbprint());
    }
}

