/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.PriorityQueue;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Throughput;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;

final class ThroughputMovingWindow {
    private final Duration window;
    private final PriorityQueue<Entry> values;

    private ThroughputMovingWindow(Duration window) {
        this.window = window;
        this.values = new PriorityQueue(Entry.COMP);
    }

    void add(Instant now, Throughput value) {
        this.removeExpiredEntries(now);
        this.values.add(new Entry(now, value));
    }

    Throughput avg(Instant now) {
        this.removeExpiredEntries(now);
        return this.values.stream().map(Entry::getValue).reduce(Throughput.zero(), (tp1, tp2) -> Throughput.of(tp1.getNumBytes() + tp2.getNumBytes(), this.window));
    }

    private void removeExpiredEntries(Instant now) {
        Instant newMin = now.minus(this.window);
        this.values.removeIf(e -> ThroughputMovingWindow.lteq(e.getAt(), newMin));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("window", this.window).add("values.size()", this.values.size()).toString();
    }

    static ThroughputMovingWindow of(Duration window) {
        return new ThroughputMovingWindow(window);
    }

    private static boolean lteq(Instant a, Instant b) {
        return a.equals(b) || a.isBefore(b);
    }

    private static final class Entry {
        private static final Comparator<Entry> COMP = Comparator.comparing(e -> e.at);
        private final Instant at;
        private final Throughput value;

        private Entry(Instant at, Throughput value) {
            this.at = at;
            this.value = value;
        }

        public Instant getAt() {
            return this.at;
        }

        public Throughput getValue() {
            return this.value;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("at", this.at).add("value", this.value).toString();
        }
    }
}

