/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.common.graph;

import java.util.Set;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.base.Supplier;
import net.snowflake.client.jdbc.internal.google.common.collect.ForwardingSet;
import net.snowflake.client.jdbc.internal.google.common.graph.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
final class InvalidatableSet<E>
extends ForwardingSet<E> {
    private final Supplier<Boolean> validator;
    private final Set<E> delegate;
    private final Supplier<String> errorMessage;

    public static final <E> InvalidatableSet<E> of(Set<E> delegate, Supplier<Boolean> validator, Supplier<String> errorMessage) {
        return new InvalidatableSet<E>(Preconditions.checkNotNull(delegate), Preconditions.checkNotNull(validator), Preconditions.checkNotNull(errorMessage));
    }

    @Override
    protected Set<E> delegate() {
        this.validate();
        return this.delegate;
    }

    private InvalidatableSet(Set<E> delegate, Supplier<Boolean> validator, Supplier<String> errorMessage) {
        this.delegate = delegate;
        this.validator = validator;
        this.errorMessage = errorMessage;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private void validate() {
        if (!this.validator.get().booleanValue()) {
            throw new IllegalStateException(this.errorMessage.get());
        }
    }
}

