/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.nio.ByteOrder;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;

final class XxHash64 {
    static final XxHash64 INSTANCE = new XxHash64(0L);
    private static final long P1 = -7046029288634856825L;
    private static final long P2 = -4417276706812531889L;
    private static final long P3 = 1609587929392839161L;
    private static final long P4 = -8796714831421723037L;
    private static final long P5 = 2870177450012600261L;
    private static final ByteOrder byteOrder = ByteOrder.nativeOrder();
    private final long seed;
    private final long voidHash;

    XxHash64(long seed) {
        this.seed = seed;
        this.voidHash = XxHash64.finalize(seed + 2870177450012600261L);
    }

    long hashLong(long input) {
        input = byteOrder == ByteOrder.LITTLE_ENDIAN ? input : Long.reverseBytes(input);
        long hash = this.seed + 2870177450012600261L + 8L;
        input *= -4417276706812531889L;
        input = Long.rotateLeft(input, 31);
        hash ^= (input *= -7046029288634856825L);
        hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
        return XxHash64.finalize(hash);
    }

    long hashInt(int input) {
        input = byteOrder == ByteOrder.LITTLE_ENDIAN ? input : Integer.reverseBytes(input);
        long hash = this.seed + 2870177450012600261L + 4L;
        hash ^= ((long)input & 0xFFFFFFFFL) * -7046029288634856825L;
        hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
        return XxHash64.finalize(hash);
    }

    long hashShort(short input) {
        input = byteOrder == ByteOrder.LITTLE_ENDIAN ? input : Short.reverseBytes(input);
        long hash = this.seed + 2870177450012600261L + 2L;
        hash ^= ((long)input & 0xFFL) * 2870177450012600261L;
        hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
        hash ^= ((long)(input >> 8) & 0xFFL) * 2870177450012600261L;
        hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
        return XxHash64.finalize(hash);
    }

    long hashChar(char input) {
        return this.hashShort((short)input);
    }

    long hashByte(byte input) {
        long hash = this.seed + 2870177450012600261L + 1L;
        hash ^= (long)(input & 0xFF) * 2870177450012600261L;
        hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
        return XxHash64.finalize(hash);
    }

    long hashVoid() {
        return this.voidHash;
    }

    long hashAsciiString(String input) {
        AsciiStringByteSupplier supplier = new AsciiStringByteSupplier(input);
        return this.hashBytes(supplier);
    }

    long hashBytes(byte[] bytes) {
        PlainByteSupplier supplier = new PlainByteSupplier(bytes);
        return this.hashBytes(supplier);
    }

    long hashBytes(byte[] bytes, int offset, int len) {
        PlainByteSupplier supplier = new PlainByteSupplier(bytes, offset, len);
        return this.hashBytes(supplier);
    }

    private long hashBytes(ByteSupplier supplier) {
        long hash;
        if (supplier.remaining() >= 32L) {
            long v1 = this.seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = this.seed + -4417276706812531889L;
            long v3 = this.seed;
            long v4 = this.seed - -7046029288634856825L;
            do {
                v1 += supplier.next64() * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += supplier.next64() * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += supplier.next64() * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += supplier.next64() * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while (supplier.remaining() >= 32L);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash ^= (v1 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash ^= (v2 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash ^= (v3 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash ^= (v4 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash = this.seed + 2870177450012600261L;
        }
        hash += supplier.bytes();
        while (supplier.remaining() >= 8L) {
            long k1 = supplier.next64();
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= -7046029288634856825L);
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
        }
        if (supplier.remaining() >= 4L) {
            hash ^= ((long)supplier.next32() & 0xFFFFFFFFL) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
        }
        while (supplier.remaining() != 0L) {
            hash ^= (long)(supplier.next8() & 0xFF) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
        }
        return XxHash64.finalize(hash);
    }

    private static long finalize(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }

    private static abstract class ByteSupplier {
        private ByteSupplier() {
        }

        public long next64() {
            return (long)this.next32() & 0xFFFFFFFFL | ((long)this.next32() & 0xFFFFFFFFL) << 32;
        }

        public int next32() {
            return this.next16() & 0xFFFF | (this.next16() & 0xFFFF) << 16;
        }

        char next16() {
            return (char)(this.next8() & 0xFF | (this.next8() & 0xFF) << 8);
        }

        abstract byte next8();

        abstract long bytes();

        abstract long remaining();
    }

    private static class AsciiStringByteSupplier
    extends ByteSupplier {
        private final String str;
        private final int bytes;
        private int pos;

        private AsciiStringByteSupplier(String str) {
            this.str = Preconditions.checkNotNull(str, "str");
            this.bytes = str.length();
        }

        @Override
        public long bytes() {
            return this.bytes;
        }

        @Override
        public long remaining() {
            return (long)this.bytes - (long)this.pos;
        }

        @Override
        public byte next8() {
            return (byte)this.str.charAt(this.pos++);
        }
    }

    private static class PlainByteSupplier
    extends ByteSupplier {
        private final byte[] src;
        private final int len;
        private int pos;
        private int remain;

        private PlainByteSupplier(byte[] src) {
            this(src, 0, src.length);
        }

        private PlainByteSupplier(byte[] src, int offset, int len) {
            this.src = Preconditions.checkNotNull(src, "src");
            Preconditions.checkArgument(offset <= src.length, "offset > src length");
            Preconditions.checkArgument(offset + len <= src.length, "offset + len > src length");
            this.len = len;
            this.pos = offset;
            this.remain = len;
        }

        @Override
        public long bytes() {
            return this.len;
        }

        @Override
        public long remaining() {
            return this.remain;
        }

        @Override
        public byte next8() {
            --this.remain;
            return this.src[this.pos++];
        }
    }
}

