/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.rpc.Code;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.annotation.Nullable;

class JdbcPreconditions {
    JdbcPreconditions() {
    }

    static void checkArgument(boolean expression, Object value) throws SQLException {
        if (!expression) {
            throw JdbcSqlExceptionFactory.of("invalid argument: " + value, Code.INVALID_ARGUMENT);
        }
    }

    static void checkState(boolean expression, @Nullable Object errorMessage) throws SQLException {
        if (!expression) {
            throw JdbcSqlExceptionFactory.of(String.valueOf(errorMessage), Code.FAILED_PRECONDITION);
        }
    }

    static void checkSqlFeatureSupported(boolean expression, String message) throws SQLFeatureNotSupportedException {
        if (!expression) {
            throw JdbcSqlExceptionFactory.unsupported(message);
        }
    }
}

