/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.base.Strings;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.google.spanner.v1.DirectedReadOptions;

public class DirectedReadOptionsUtil {
    public static String toString(DirectedReadOptions directedReadOptions) {
        if (directedReadOptions == null || DirectedReadOptions.getDefaultInstance().equals((Object)directedReadOptions)) {
            return "";
        }
        try {
            return JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)directedReadOptions);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw SpannerExceptionFactory.asSpannerException(invalidProtocolBufferException);
        }
    }

    static DirectedReadOptions parse(String json) {
        if (Strings.isNullOrEmpty((String)json)) {
            return DirectedReadOptions.getDefaultInstance();
        }
        DirectedReadOptions.Builder builder = DirectedReadOptions.newBuilder();
        try {
            JsonFormat.parser().merge(json, (Message.Builder)builder);
            return builder.build();
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw SpannerExceptionFactory.asSpannerException(invalidProtocolBufferException);
        }
    }
}

