/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.jdbc.AbstractFieldMetaData;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FirebirdResultSetMetaData;

public class FBResultSetMetaData
extends AbstractFieldMetaData
implements FirebirdResultSetMetaData {
    private static final int ID_UNICODE_FSS = 3;
    private final ColumnStrategy columnStrategy;
    private static final String GET_FIELD_INFO = "SELECT   RF.RDB$RELATION_NAME as RELATION_NAME, RF.RDB$FIELD_NAME as FIELD_NAME, F.RDB$FIELD_LENGTH as FIELD_LENGTH, F.RDB$FIELD_PRECISION as FIELD_PRECISION, F.RDB$FIELD_SCALE as FIELD_SCALE, F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE, F.RDB$CHARACTER_SET_ID as CHARACTER_SET_ID, F.RDB$SYSTEM_FLAG as SYSTEM_FLAG, F.RDB$CHARACTER_LENGTH as CHAR_LEN FROM  RDB$RELATION_FIELDS RF , RDB$FIELDS F  WHERE   RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME AND  RF.RDB$FIELD_NAME = ? AND  RF.RDB$RELATION_NAME = ?";

    protected FBResultSetMetaData(RowDescriptor rowDescriptor, FBConnection connection) throws SQLException {
        super(rowDescriptor, connection);
        this.columnStrategy = FBResultSetMetaData.isColumnLabelForName(connection) ? ColumnStrategy.COLUMN_LABEL_FOR_NAME : ColumnStrategy.DEFAULT;
    }

    private static boolean isColumnLabelForName(FBConnection connection) throws SQLException {
        if (connection == null) {
            return false;
        }
        GDSHelper gdsHelper = connection.getGDSHelper();
        return gdsHelper != null && gdsHelper.getConnectionProperties().isColumnLabelForName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.getFieldCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        int sqlType = this.getFieldDescriptor(column).getType() & 0xFFFFFFFE;
        return sqlType != 540 && sqlType != 520;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return (this.getFieldDescriptor(column).getType() & 1) == 1 ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.isSignedInternal(column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int colType = this.getColumnType(column);
        int precision = this.getPrecision(column);
        switch (colType) {
            case 2: 
            case 3: {
                return precision + 2;
            }
            case 6: 
            case 8: {
                return precision + 2;
            }
            case -5: 
            case 4: 
            case 5: {
                return precision + 1;
            }
        }
        return precision;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnStrategy.getColumnLabel(this.getFieldDescriptor(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnStrategy.getColumnName(this.getFieldDescriptor(column));
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getPrecisionInternal(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getScaleInternal(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        String result = this.getFieldDescriptor(column).getOriginalTableName();
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getTableAlias(int column) throws SQLException {
        String result = this.getFieldDescriptor(column).getTableAlias();
        if (result == null) {
            result = this.getTableName(column);
        }
        return result;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getFieldType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getFieldTypeName(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getFieldClassName(column);
    }

    @Override
    protected Map<AbstractFieldMetaData.FieldKey, AbstractFieldMetaData.ExtendedFieldInfo> getExtendedFieldInfo(FBConnection connection) throws SQLException {
        if (connection == null) {
            return Collections.emptyMap();
        }
        int pending = this.getFieldCount();
        HashMap<AbstractFieldMetaData.FieldKey, AbstractFieldMetaData.ExtendedFieldInfo> result = new HashMap<AbstractFieldMetaData.FieldKey, AbstractFieldMetaData.ExtendedFieldInfo>();
        FBDatabaseMetaData metaData = (FBDatabaseMetaData)connection.getMetaData();
        while (pending > 0) {
            StringBuilder sb = new StringBuilder();
            int maxLength = Math.min(pending, 70);
            ArrayList<String> params = new ArrayList<String>(2 * maxLength);
            for (int i = 1; i <= maxLength; ++i) {
                String relationName = this.getFieldDescriptor(i).getOriginalTableName();
                String fieldName = this.getFieldDescriptor(i).getOriginalName();
                if (relationName == null || relationName.equals("") || fieldName == null || fieldName.equals("")) continue;
                if (sb.length() > 0) {
                    sb.append('\n').append("UNION ALL").append('\n');
                }
                sb.append(GET_FIELD_INFO);
                params.add(fieldName);
                params.add(relationName);
            }
            pending -= maxLength;
            if (sb.length() == 0) continue;
            try (ResultSet rs = metaData.doQuery(sb.toString(), params, true);){
                while (rs.next()) {
                    AbstractFieldMetaData.ExtendedFieldInfo fieldInfo = new AbstractFieldMetaData.ExtendedFieldInfo();
                    fieldInfo.relationName = rs.getString("RELATION_NAME");
                    fieldInfo.fieldName = rs.getString("FIELD_NAME");
                    fieldInfo.fieldLength = rs.getInt("FIELD_LENGTH");
                    fieldInfo.fieldPrecision = rs.getInt("FIELD_PRECISION");
                    fieldInfo.fieldScale = rs.getInt("FIELD_SCALE");
                    fieldInfo.fieldSubtype = rs.getInt("FIELD_SUB_TYPE");
                    fieldInfo.characterSetId = rs.getInt("CHARACTER_SET_ID");
                    boolean systemField = rs.getBoolean("SYSTEM_FLAG");
                    fieldInfo.characterLength = rs.getInt("CHAR_LEN");
                    if (rs.wasNull()) {
                        if (systemField && fieldInfo.characterSetId == 3) {
                            fieldInfo.characterLength = fieldInfo.fieldLength;
                        } else {
                            IEncodingFactory encodingFactory = this.getRowDescriptor().getEncodingFactory();
                            EncodingDefinition encodingDefinition = encodingFactory.getEncodingDefinitionByCharacterSetId(fieldInfo.characterSetId);
                            int charsetSize = encodingDefinition != null ? encodingDefinition.getMaxBytesPerChar() : 1;
                            fieldInfo.characterLength = fieldInfo.fieldLength / charsetSize;
                        }
                    }
                    result.put(new AbstractFieldMetaData.FieldKey(fieldInfo.relationName, fieldInfo.fieldName), fieldInfo);
                }
            }
            params.clear();
        }
        return result;
    }

    private static enum ColumnStrategy {
        DEFAULT{

            @Override
            String getColumnName(FieldDescriptor fieldDescriptor) {
                return fieldDescriptor.getOriginalName() != null ? fieldDescriptor.getOriginalName() : this.getColumnLabel(fieldDescriptor);
            }
        }
        ,
        COLUMN_LABEL_FOR_NAME{

            @Override
            String getColumnName(FieldDescriptor fieldDescriptor) {
                return this.getColumnLabel(fieldDescriptor);
            }
        };


        abstract String getColumnName(FieldDescriptor var1);

        String getColumnLabel(FieldDescriptor fieldDescriptor) {
            if (fieldDescriptor.getFieldName() != null) {
                return fieldDescriptor.getFieldName();
            }
            if (fieldDescriptor.getOriginalName() != null) {
                return fieldDescriptor.getOriginalName();
            }
            return "";
        }
    }
}

