/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.commandline.Main;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.CommandLineConfigurationUtils;
import org.flywaydb.commandline.configuration.ConfigurationManager;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class LegacyConfigurationManager
implements ConfigurationManager {
    private static final Log LOG = LogFactory.getLog(LegacyConfigurationManager.class);

    @Override
    public Configuration getConfiguration(CommandLineArguments commandLineArguments) {
        Map<String, String> config = new HashMap<String, String>();
        String installDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : ClassUtils.getInstallDir(Main.class);
        String workingDirectory = commandLineArguments.getWorkingDirectoryOrNull();
        File jarDir = new File(installDirectory, "jars");
        ConfigUtils.warnIfUsingDeprecatedMigrationsFolder((File)jarDir, (String)".jar");
        if (jarDir.exists()) {
            config.put("flyway.jarDirs", jarDir.getAbsolutePath());
        }
        Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
        this.loadConfigurationFromConfigFiles(config, commandLineArguments, envVars);
        config.putAll(envVars);
        config = LegacyConfigurationManager.overrideConfiguration(config, commandLineArguments.getConfiguration(false));
        File sqlFolder = new File(installDirectory, "sql");
        if (ConfigUtils.shouldUseDefaultCliSqlLocation((File)sqlFolder, (boolean)StringUtils.hasText((String)config.get("flyway.locations")))) {
            config.put("flyway.locations", "filesystem:" + sqlFolder.getAbsolutePath());
        }
        if (workingDirectory != null) {
            ConfigUtils.makeRelativeLocationsBasedOnWorkingDirectory((String)workingDirectory, config);
            ConfigUtils.makeRelativeJarDirsBasedOnWorkingDirectory((String)workingDirectory, config);
        }
        ClassLoader classLoader = this.buildClassLoaderBasedOnJarDirs(Thread.currentThread().getContextClassLoader(), config);
        ConfigUtils.dumpConfigurationMap(config, (String)"Using configuration:");
        this.filterProperties(config);
        return new FluentConfiguration(classLoader).configuration(config).workingDirectory(workingDirectory);
    }

    protected void loadConfigurationFromConfigFiles(Map<String, String> config, CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        String encoding = LegacyConfigurationManager.determineConfigurationFileEncoding(commandLineArguments, envVars);
        File installationDir = new File(ClassUtils.getInstallDir(Main.class));
        String workingDirectory = commandLineArguments.getWorkingDirectoryOrNull();
        config.putAll(ConfigUtils.loadDefaultConfigurationFiles((File)installationDir, (String)workingDirectory, (String)encoding));
        for (File configFile : LegacyConfigurationManager.determineLegacyConfigFilesFromArgs(commandLineArguments)) {
            config.putAll(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
    }

    private static String determineConfigurationFileEncoding(CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        if (commandLineArguments.isConfigFileEncodingSet()) {
            return commandLineArguments.getConfigFileEncoding();
        }
        return "UTF-8";
    }

    private static List<File> determineLegacyConfigFilesFromArgs(CommandLineArguments commandLineArguments) {
        List<File> legacyFiles = commandLineArguments.getConfigFilePathsFromEnv(false);
        legacyFiles.addAll(commandLineArguments.getConfigFiles().stream().filter(s -> !s.endsWith(".toml")).map(File::new).toList());
        return legacyFiles;
    }

    private static Map<String, String> overrideConfiguration(Map<String, String> existingConfiguration, Map<String, String> newConfiguration) {
        HashMap<String, String> combinedConfiguration = new HashMap<String, String>();
        combinedConfiguration.putAll(existingConfiguration);
        combinedConfiguration.putAll(newConfiguration);
        return combinedConfiguration;
    }

    private void filterProperties(Map<String, String> config) {
        config.remove("flyway.configFiles");
        config.remove("flyway.configFileEncoding");
    }

    private ClassLoader buildClassLoaderBasedOnJarDirs(ClassLoader parentClassLoader, Map<String, String> config) {
        ArrayList<File> jarFiles = new ArrayList<File>(CommandLineConfigurationUtils.getJdbcDriverJarFiles());
        String jarDirs = config.get("flyway.jarDirs");
        if (StringUtils.hasText((String)jarDirs)) {
            jarFiles.addAll(CommandLineConfigurationUtils.getJavaMigrationJarFiles(StringUtils.tokenizeToStringArray((String)jarDirs.replace(File.pathSeparator, ","), (String)",")));
        }
        if (!jarFiles.isEmpty()) {
            return ClassUtils.addJarsOrDirectoriesToClasspath((ClassLoader)parentClassLoader, jarFiles);
        }
        return parentClassLoader;
    }
}

