/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.api;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc.common.DSTrustManager;
import com.databricks.client.jdbc.common.SSLTransportParameters;
import com.databricks.client.jdbc.rpc.HttpClientFactory;
import com.databricks.client.jdbc42.internal.apache.http.conn.DnsResolver;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TSocket;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TETSSLTransportFactory {
    private static final String PROTOCOL_SSL = "SSL";

    public static TSocket getClientSocket(HiveJDBCSettings hiveJDBCSettings, SSLTransportParameters sSLTransportParameters, SocketFactory socketFactory, ILogger iLogger) throws ErrorException {
        return TETSSLTransportFactory.getClientSocket(hiveJDBCSettings, sSLTransportParameters, socketFactory, null, iLogger);
    }

    public static TSocket getClientSocket(HiveJDBCSettings hiveJDBCSettings, SSLTransportParameters sSLTransportParameters, SocketFactory socketFactory, Socket socket, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, sSLTransportParameters, socketFactory, socket);
        if (null == sSLTransportParameters) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SSL_PARAMS_NOT_SET.name());
            throw errorException;
        }
        SSLContext sSLContext = TETSSLTransportFactory.createSSLContext(sSLTransportParameters, hiveJDBCSettings.m_host);
        return TETSSLTransportFactory.createClient(hiveJDBCSettings, sSLContext, socketFactory, socket);
    }

    public static HttpClientBuilder getHttpsClient(HiveJDBCSettings hiveJDBCSettings, SSLTransportParameters sSLTransportParameters, SocketFactory socketFactory, DnsResolver dnsResolver, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, sSLTransportParameters, socketFactory, dnsResolver);
        if (null == sSLTransportParameters) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SSL_PARAMS_NOT_SET.name());
            throw errorException;
        }
        SSLContext sSLContext = TETSSLTransportFactory.createSSLContext(sSLTransportParameters, hiveJDBCSettings.m_host);
        return HttpClientFactory.createHttpClientBuilder(socketFactory, sSLContext, dnsResolver, sSLTransportParameters.getCertNamesMismatch() || sSLTransportParameters.getAllowSelfSigned(), hiveJDBCSettings.m_proxySettings, hiveJDBCSettings.m_timeout, iLogger);
    }

    private static String[] removeSSLProtocols(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Input protocols = '");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            stringBuffer.append(string);
            stringBuffer.append(",");
            if (null == string || string.toUpperCase().contains(PROTOCOL_SSL)) continue;
            arrayList.add(string);
        }
        stringBuffer.append("', enabled protocols = '");
        for (String string : arrayList) {
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        stringBuffer.append("'");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static SSLContext createSSLContext(SSLTransportParameters sSLTransportParameters, String string) throws ErrorException {
        SSLContext sSLContext;
        try {
            Object object;
            TrustManager[] trustManagerArray;
            sSLContext = SSLContext.getInstance(sSLTransportParameters.getProtocol());
            KeyManager[] keyManagerArray = null;
            if (sSLTransportParameters.isKeyStoreSet) {
                trustManagerArray = KeyManagerFactory.getInstance(sSLTransportParameters.getKeyManagerType());
                object = null != sSLTransportParameters.getKeyStoreProvider() ? KeyStore.getInstance(sSLTransportParameters.getKeyStoreType(), sSLTransportParameters.getKeyStoreProvider()) : KeyStore.getInstance(sSLTransportParameters.getKeyStoreType());
                char[] cArray = null;
                if (null != sSLTransportParameters.getKeyPass()) {
                    cArray = sSLTransportParameters.getKeyPass().toCharArray();
                }
                ((KeyStore)object).load(new FileInputStream(sSLTransportParameters.getKeyStore()), cArray);
                trustManagerArray.init((KeyStore)object, cArray);
                keyManagerArray = trustManagerArray.getKeyManagers();
            }
            trustManagerArray = new TrustManager[]{new DSTrustManager(sSLTransportParameters, string)};
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            object = sSLContext.createSSLEngine();
            ((SSLEngine)object).setEnabledProtocols(TETSSLTransportFactory.removeSSLProtocols(((SSLEngine)object).getEnabledProtocols()));
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        return sSLContext;
    }

    private static TSocket createClient(HiveJDBCSettings hiveJDBCSettings, SSLContext sSLContext, SocketFactory socketFactory, Socket socket) throws ErrorException {
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        try {
            Socket socket2 = null;
            if (null != socketFactory) {
                socket2 = socketFactory.createSocket();
                socket2.connect(new InetSocketAddress(hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost, hiveJDBCSettings.m_port));
            } else if (null != socket) {
                socket2 = socket;
            }
            SSLSocket sSLSocket = null == socket2 ? (SSLSocket)sSLSocketFactory.createSocket(hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost, hiveJDBCSettings.m_port) : (SSLSocket)sSLSocketFactory.createSocket(socket2, hiveJDBCSettings.m_host, hiveJDBCSettings.m_port, true);
            sSLSocket.setSoTimeout(hiveJDBCSettings.m_timeout);
            sSLSocket.setEnabledProtocols(TETSSLTransportFactory.removeSSLProtocols(sSLSocket.getEnabledProtocols()));
            TSocket tSocket = new TSocket(sSLSocket);
            tSocket.setTimeout(hiveJDBCSettings.m_timeout);
            return tSocket;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_THRIFT_COULD_NOT_CONNECT.name(), new String[]{hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost, String.valueOf(hiveJDBCSettings.m_port)});
            errorException.initCause(exception);
            throw errorException;
        }
    }
}

