/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl;

import com.databricks.client.jdbc42.internal.apache.arrow.memory.ArrowBuf;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.VarCharVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableVarCharHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.VarCharHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.Text;

public class VarCharWriterImpl
extends AbstractFieldWriter {
    final VarCharVector vector;
    private final Text textBuffer = new Text();

    public VarCharWriterImpl(VarCharVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(VarCharHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableVarCharHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarChar(int start, int end, ArrowBuf buffer) {
        this.vector.setSafe(this.idx(), 1, start, end, buffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarChar(Text value) {
        this.vector.setSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarChar(String value) {
        this.textBuffer.set(value);
        this.vector.setSafe(this.idx(), this.textBuffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

