/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.internal.async.AsyncConsumer;
import com.mongodb.internal.async.AsyncFunction;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.lang.Nullable;
import java.util.function.Predicate;

@FunctionalInterface
public interface AsyncSupplier<T>
extends AsyncFunction<Void, T> {
    public void unsafeFinish(SingleResultCallback<T> var1);

    default public void getAsync(SingleResultCallback<T> callback) {
        this.finish(callback);
    }

    @Override
    default public void unsafeFinish(@Nullable Void value, SingleResultCallback<T> callback) {
        this.unsafeFinish(callback);
    }

    default public void finish(SingleResultCallback<T> callback) {
        boolean[] callbackInvoked = new boolean[]{false};
        try {
            this.unsafeFinish((v, e) -> {
                callbackInvoked[0] = true;
                callback.onResult(v, e);
            });
        }
        catch (Throwable t) {
            if (callbackInvoked[0]) {
                throw t;
            }
            callback.completeExceptionally(t);
        }
    }

    default public <R> AsyncSupplier<R> thenApply(AsyncFunction<T, R> function) {
        return c -> this.unsafeFinish((v, e) -> {
            if (e == null) {
                function.unsafeFinish(v, c);
            } else {
                c.completeExceptionally(e);
            }
        });
    }

    default public AsyncRunnable thenConsume(AsyncConsumer<T> consumer) {
        return c -> this.unsafeFinish((v, e) -> {
            if (e == null) {
                consumer.unsafeFinish(v, c);
            } else {
                c.completeExceptionally(e);
            }
        });
    }

    default public AsyncSupplier<T> onErrorIf(Predicate<Throwable> errorCheck, AsyncFunction<Throwable, T> errorFunction) {
        return callback -> this.finish((r, e) -> {
            boolean errorMatched;
            if (e == null) {
                callback.complete(r);
                return;
            }
            try {
                errorMatched = errorCheck.test(e);
            }
            catch (Throwable t) {
                t.addSuppressed(e);
                callback.completeExceptionally(t);
                return;
            }
            if (errorMatched) {
                errorFunction.unsafeFinish(e, callback);
            } else {
                callback.completeExceptionally(e);
            }
        });
    }
}

