import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Text } from 'ink';
export const HooksList = ({ hooks }) => {
    if (hooks.length === 0) {
        return (_jsx(Box, { marginTop: 1, marginBottom: 1, children: _jsx(Text, { children: "No hooks configured." }) }));
    }
    // Group hooks by event name for better organization
    const hooksByEvent = hooks.reduce((acc, hook) => {
        if (!acc[hook.eventName]) {
            acc[hook.eventName] = [];
        }
        acc[hook.eventName].push(hook);
        return acc;
    }, {});
    return (_jsxs(Box, { flexDirection: "column", marginTop: 1, marginBottom: 1, children: [_jsx(Text, { bold: true, children: "Configured Hooks:" }), _jsx(Box, { flexDirection: "column", paddingLeft: 2, marginTop: 1, children: Object.entries(hooksByEvent).map(([eventName, eventHooks]) => (_jsxs(Box, { flexDirection: "column", marginBottom: 1, children: [_jsxs(Text, { color: "cyan", bold: true, children: [eventName, ":"] }), _jsx(Box, { flexDirection: "column", paddingLeft: 2, children: eventHooks.map((hook, index) => {
                                const hookName = hook.config.name || hook.config.command || 'unknown';
                                const statusColor = hook.enabled ? 'green' : 'gray';
                                const statusText = hook.enabled ? 'enabled' : 'disabled';
                                return (_jsxs(Box, { flexDirection: "column", children: [_jsx(Box, { children: _jsxs(Text, { children: [_jsx(Text, { color: "yellow", children: hookName }), _jsx(Text, { color: statusColor, children: ` [${statusText}]` })] }) }), _jsxs(Box, { paddingLeft: 2, flexDirection: "column", children: [hook.config.description && (_jsx(Text, { italic: true, children: hook.config.description })), _jsxs(Text, { dimColor: true, children: ["Source: ", hook.source, hook.config.name &&
                                                            hook.config.command &&
                                                            ` | Command: ${hook.config.command}`, hook.matcher && ` | Matcher: ${hook.matcher}`, hook.sequential && ` | Sequential`, hook.config.timeout &&
                                                            ` | Timeout: ${hook.config.timeout}s`] })] })] }, `${eventName}-${index}`));
                            }) })] }, eventName))) }), _jsx(Box, { marginTop: 1, children: _jsxs(Text, { dimColor: true, children: ["Tip: Use `/hooks enable ", '<hook-name>', "` or `/hooks disable", ' ', '<hook-name>', "` to toggle hooks"] }) })] }));
};
//# sourceMappingURL=HooksList.js.map