!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Routines to manage GILDAS LIST messages
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubelist_messaging
  use gpack_def
  use gbl_message
  use cubetools_parameters
  !
  public :: seve,mess_l
  public :: cubelist_message_set_id,cubelist_message
  private
  !
  ! Identifier used for message identification
  integer(kind=4) :: cubelist_message_id = gpack_global_id  ! Default value for startup message
  !
contains
  !
  subroutine cubelist_message_set_id(id)
    !---------------------------------------------------------------------
    ! Alter library id into input id. Should be called by the library
    ! which wants to share its id with the current one.
    !---------------------------------------------------------------------
    integer(kind=4), intent(in) :: id
    !
    character(len=message_length) :: mess
    character(len=*), parameter :: rname='MESSAGE>SET>ID'
    !
    cubelist_message_id = id
    write (mess,'(A,I0)') 'Now use id #',cubelist_message_id
    call cubelist_message(seve%d,rname,mess)
  end subroutine cubelist_message_set_id
  !
  subroutine cubelist_message(mkind,procname,message)
    use cubetools_cmessaging
    !---------------------------------------------------------------------
    ! Messaging facility for the current library. Calls the low-level
    ! (internal) messaging routine with its own identifier.
    !---------------------------------------------------------------------
    integer(kind=4),  intent(in) :: mkind     ! Message kind
    character(len=*), intent(in) :: procname  ! Name of calling procedure
    character(len=*), intent(in) :: message   ! Message string
    !
    call cubetools_cmessage(cubelist_message_id,mkind,'LIST>'//procname,message)
  end subroutine cubelist_message
  !
end module cubelist_messaging
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
